/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jdbc;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonArray;
import io.vertx.ext.jdbc.JDBCClient;
import io.vertx.ext.sql.ResultSet;
import io.vertx.ext.sql.SQLClient;
import io.vertx.ext.sql.SQLConnection;
import io.vertx.ext.sql.SQLOptions;
import io.vertx.ext.sql.SQLRowStream;
import io.vertx.ext.sql.TransactionIsolation;
import io.vertx.ext.sql.UpdateResult;
import java.util.List;

public class CloseConnectionChecker
implements JDBCClient {
    private final SQLClient delegate;
    private final Handler<Void> onConnectionClosed;

    CloseConnectionChecker(SQLClient delegate, Handler<Void> onConnectionClosed) {
        this.delegate = delegate;
        this.onConnectionClosed = onConnectionClosed;
    }

    public SQLClient getConnection(Handler<AsyncResult<SQLConnection>> handler) {
        this.delegate.getConnection(conn -> {
            if (conn.succeeded()) {
                handler.handle((Object)Future.succeededFuture((Object)new SQLConnectionWrapper((SQLConnection)conn.result())));
            } else {
                handler.handle(conn);
            }
        });
        return this;
    }

    public void close(Handler<AsyncResult<Void>> handler) {
        this.delegate.close(handler);
    }

    public void close() {
        this.delegate.close();
    }

    private class SQLConnectionWrapper
    implements SQLConnection {
        private final SQLConnection delegate;

        SQLConnectionWrapper(SQLConnection delegate) {
            this.delegate = delegate;
        }

        public SQLConnection setOptions(SQLOptions options) {
            this.delegate.setOptions(options);
            return this;
        }

        public SQLConnection setAutoCommit(boolean autoCommit, Handler<AsyncResult<Void>> resultHandler) {
            this.delegate.setAutoCommit(autoCommit, resultHandler);
            return this;
        }

        public SQLConnection execute(String sql, Handler<AsyncResult<Void>> resultHandler) {
            this.delegate.execute(sql, resultHandler);
            return this;
        }

        public SQLConnection query(String sql, Handler<AsyncResult<ResultSet>> resultHandler) {
            this.delegate.query(sql, resultHandler);
            return this;
        }

        public SQLConnection queryStream(String sql, Handler<AsyncResult<SQLRowStream>> handler) {
            this.delegate.queryStream(sql, handler);
            return this;
        }

        public SQLConnection queryWithParams(String sql, JsonArray params, Handler<AsyncResult<ResultSet>> resultHandler) {
            this.delegate.queryWithParams(sql, params, resultHandler);
            return this;
        }

        public SQLConnection queryStreamWithParams(String sql, JsonArray params, Handler<AsyncResult<SQLRowStream>> handler) {
            this.delegate.queryStreamWithParams(sql, params, handler);
            return this;
        }

        public SQLConnection update(String sql, Handler<AsyncResult<UpdateResult>> resultHandler) {
            this.delegate.update(sql, resultHandler);
            return this;
        }

        public SQLConnection updateWithParams(String sql, JsonArray params, Handler<AsyncResult<UpdateResult>> resultHandler) {
            this.delegate.updateWithParams(sql, params, resultHandler);
            return this;
        }

        public SQLConnection call(String sql, Handler<AsyncResult<ResultSet>> resultHandler) {
            this.delegate.call(sql, resultHandler);
            return this;
        }

        public SQLConnection callWithParams(String sql, JsonArray params, JsonArray outputs, Handler<AsyncResult<ResultSet>> resultHandler) {
            this.delegate.callWithParams(sql, params, outputs, resultHandler);
            return this;
        }

        public void close(Handler<AsyncResult<Void>> handler) {
            this.delegate.close(ar -> {
                if (ar.succeeded()) {
                    handler.handle(ar);
                    CloseConnectionChecker.this.onConnectionClosed.handle(null);
                } else {
                    handler.handle(ar);
                }
            });
        }

        public void close() {
            this.delegate.close();
            CloseConnectionChecker.this.onConnectionClosed.handle(null);
        }

        public SQLConnection commit(Handler<AsyncResult<Void>> handler) {
            this.delegate.commit(handler);
            return this;
        }

        public SQLConnection rollback(Handler<AsyncResult<Void>> handler) {
            this.delegate.rollback(handler);
            return this;
        }

        public SQLConnection batch(List<String> sqlStatements, Handler<AsyncResult<List<Integer>>> handler) {
            this.delegate.batch(sqlStatements, handler);
            return this;
        }

        public SQLConnection batchWithParams(String sqlStatement, List<JsonArray> args, Handler<AsyncResult<List<Integer>>> handler) {
            this.delegate.batchWithParams(sqlStatement, args, handler);
            return this;
        }

        public SQLConnection batchCallableWithParams(String sqlStatement, List<JsonArray> inArgs, List<JsonArray> outArgs, Handler<AsyncResult<List<Integer>>> handler) {
            this.delegate.batchCallableWithParams(sqlStatement, inArgs, outArgs, handler);
            return this;
        }

        public SQLConnection setTransactionIsolation(TransactionIsolation isolation, Handler<AsyncResult<Void>> handler) {
            this.delegate.setTransactionIsolation(isolation, handler);
            return this;
        }

        public SQLConnection getTransactionIsolation(Handler<AsyncResult<TransactionIsolation>> handler) {
            this.delegate.getTransactionIsolation(handler);
            return this;
        }
    }
}

