/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jdbc;

import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.jdbc.CloseConnectionChecker;
import io.vertx.ext.jdbc.JDBCClient;
import io.vertx.ext.jdbc.JDBCClientTestBase;
import io.vertx.ext.jdbc.impl.actions.AbstractJDBCAction;
import io.vertx.ext.sql.ResultSet;
import io.vertx.ext.sql.SQLClient;
import io.vertx.ext.sql.SQLConnection;
import io.vertx.ext.sql.SQLOptions;
import io.vertx.ext.sql.SQLRowStream;
import io.vertx.ext.sql.UpdateResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.TimeZone;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.logging.Level;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class JDBCClientTest
extends JDBCClientTestBase {
    protected SQLClient client;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.client = JDBCClient.create((Vertx)this.vertx, (JsonObject)JDBCClientTest.config());
    }

    @After
    public void after() throws Exception {
        this.client.close();
        super.after();
    }

    @Test
    public void testSqlClientInstance() {
        this.assertTrue(this.client instanceof SQLClient);
        this.testComplete();
    }

    @Test
    public void testJdbcClientInstance() {
        this.assertTrue(this.client instanceof JDBCClient);
        this.testComplete();
    }

    @Test
    public void testGetNativeConn() {
        this.assertNotNull(this.connection().unwrap());
        this.testComplete();
    }

    private SQLClient checker() {
        return new CloseConnectionChecker(this.client, (Handler<Void>)((Handler)v -> {
            System.out.println("connection closed");
            this.testComplete();
        }));
    }

    @Test
    public void testOneShotStream1() {
        this.testOneShotStream1(res -> null);
    }

    @Test
    public void testOneShotStream2() {
        this.testOneShotStream1(res -> v -> res.moreResults());
    }

    @Test
    public void testOneShotStream3() {
        this.testOneShotStream1(res -> v -> res.close());
    }

    private void testOneShotStream1(Function<SQLRowStream, Handler<Void>> h) {
        AtomicInteger cnt = new AtomicInteger(0);
        this.checker().queryStream("SELECT * FROM big_table", this.onSuccess(res -> res.resultSetClosedHandler((Handler)h.apply((SQLRowStream)res)).handler(row -> cnt.incrementAndGet()).endHandler(v -> this.assertEquals(200L, cnt.get())).exceptionHandler(arg_0 -> ((JDBCClientTest)this).fail(arg_0))));
        this.await();
    }

    @Test
    public void testOneShotStream4() {
        AtomicInteger cnt = new AtomicInteger(0);
        this.checker().queryStream("SELECT * FROM big_table", this.onSuccess(res -> res.resultSetClosedHandler(v -> this.fail(new RuntimeException("wrong state"))).handler(row -> {
            if (cnt.incrementAndGet() > 100) {
                res.close();
            }
        }).endHandler(v -> this.fail(new RuntimeException())).exceptionHandler(t -> this.fail((Throwable)t))));
        this.await();
    }

    @Test
    public void testSelect() {
        String sql = "SELECT ID, FNAME, LNAME FROM select_table ORDER BY ID";
        this.connection().query(sql, this.onSuccess(resultSet -> {
            this.assertNotNull(resultSet);
            this.assertEquals(2L, resultSet.getResults().size());
            this.assertEquals("ID", resultSet.getColumnNames().get(0));
            this.assertEquals("FNAME", resultSet.getColumnNames().get(1));
            this.assertEquals("LNAME", resultSet.getColumnNames().get(2));
            JsonArray result0 = (JsonArray)resultSet.getResults().get(0);
            this.assertEquals(1L, result0.getInteger(0).intValue());
            this.assertEquals("john", result0.getString(1));
            this.assertEquals("doe", result0.getString(2));
            JsonArray result1 = (JsonArray)resultSet.getResults().get(1);
            this.assertEquals(2L, result1.getInteger(0).intValue());
            this.assertEquals("jane", result1.getString(1));
            this.assertEquals("doe", result1.getString(2));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testSelectOneShot() {
        String sql = "SELECT ID, FNAME, LNAME FROM select_table ORDER BY ID";
        this.client.query(sql, query -> {
            this.assertFalse(query.failed());
            ResultSet resultSet = (ResultSet)query.result();
            this.assertNotNull(resultSet);
            this.assertEquals(2L, resultSet.getResults().size());
            this.assertEquals("ID", resultSet.getColumnNames().get(0));
            this.assertEquals("FNAME", resultSet.getColumnNames().get(1));
            this.assertEquals("LNAME", resultSet.getColumnNames().get(2));
            JsonArray result0 = (JsonArray)resultSet.getResults().get(0);
            this.assertEquals(1L, result0.getInteger(0).intValue());
            this.assertEquals("john", result0.getString(1));
            this.assertEquals("doe", result0.getString(2));
            JsonArray result1 = (JsonArray)resultSet.getResults().get(1);
            this.assertEquals(2L, result1.getInteger(0).intValue());
            this.assertEquals("jane", result1.getString(1));
            this.assertEquals("doe", result1.getString(2));
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testSelectOneContext() {
        Context context = this.vertx.getOrCreateContext();
        context.runOnContext(v -> this.client.query("VALUES (CURRENT_TIMESTAMP)", this.onSuccess(query -> {
            this.assertEquals(context, this.vertx.getOrCreateContext());
            this.testComplete();
        })));
        this.await();
    }

    @Test
    public void testSelectOneShotFail() {
        String sql = "SELECTA ID, FNAME, LNAME FROM select_table ORDER BY ID";
        this.client.query(sql, query -> {
            this.assertTrue(query.failed());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testSelectOneShotSingle() {
        String sql = "SELECT ID, FNAME, LNAME FROM select_table WHERE ID = 2";
        this.client.querySingle(sql, query -> {
            this.assertFalse(query.failed());
            JsonArray row = (JsonArray)query.result();
            this.assertNotNull(row);
            this.assertEquals(2L, row.getInteger(0).intValue());
            this.assertEquals("jane", row.getString(1));
            this.assertEquals("doe", row.getString(2));
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testInsertOneShot() {
        String sql = "INSERT INTO insert_table (FNAME, LNAME) VALUES (?,?)";
        this.client.updateWithParams(sql, new JsonArray().add("Paulo").add("Lopes"), this.onSuccess(result -> {
            this.assertUpdate((UpdateResult)result, 1, true);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testStream() {
        String sql = "SELECT ID, FNAME, LNAME FROM select_table ORDER BY ID";
        AtomicInteger cnt = new AtomicInteger(0);
        this.connection().queryStream(sql, this.onSuccess(res -> res.resultSetClosedHandler(v -> res.moreResults()).handler(row -> cnt.incrementAndGet()).endHandler(v -> {
            this.assertEquals(2L, cnt.get());
            this.testComplete();
        }).exceptionHandler(t -> this.fail((Throwable)t))));
        this.await();
    }

    @Test
    public void testStreamOnClosedConnection() {
        String sql = "SELECT ID, FNAME, LNAME FROM select_table ORDER BY ID";
        AtomicInteger cnt = new AtomicInteger(0);
        SQLConnection conn = this.connection();
        conn.queryStream(sql, this.onSuccess(res -> {
            conn.close();
            res.resultSetClosedHandler(v -> this.fail("Should not happen")).handler(row -> this.fail("Should not happen")).endHandler(v -> this.fail("Should not happen")).exceptionHandler(t -> this.testComplete());
        }));
        this.await();
    }

    @Test
    public void testStreamWithParams() {
        String sql = "SELECT ID, FNAME, LNAME FROM select_table WHERE LNAME = ? ORDER BY ID";
        AtomicInteger cnt = new AtomicInteger(0);
        this.connection().queryStreamWithParams(sql, new JsonArray().add("doe"), this.onSuccess(res -> res.handler(row -> cnt.incrementAndGet()).endHandler(v -> {
            this.assertEquals(2L, cnt.get());
            this.testComplete();
        }).exceptionHandler(t -> this.fail((Throwable)t))));
        this.await();
    }

    @Test
    public void testStreamAbort() {
        String sql = "SELECT ID, FNAME, LNAME FROM select_table ORDER BY ID";
        this.connection().queryStream(sql, this.onSuccess(res -> res.handler(row -> res.close(close -> this.testComplete())).endHandler(v -> this.fail("Should not be called")).exceptionHandler(t -> this.fail((Throwable)t))));
        this.await();
    }

    @Test
    public void testStreamPauseResumeFlowControl() {
        this.testStreamFlowControl((Handler<SQLRowStream>)((Handler)stream -> {}), (Handler<SQLRowStream>)((Handler)stream -> {
            stream.pause();
            this.vertx.setTimer(1000L, v -> stream.resume());
        }));
    }

    @Test
    public void testStreamFetchFlowControl() {
        AtomicBoolean paused = new AtomicBoolean();
        this.testStreamFlowControl((Handler<SQLRowStream>)((Handler)stream -> {
            stream.pause();
            stream.fetch(1L);
        }), (Handler<SQLRowStream>)((Handler)stream -> {
            this.assertFalse(paused.getAndSet(true));
            this.vertx.setTimer(1000L, v -> {
                paused.set(false);
                stream.fetch(1L);
            });
        }));
    }

    public void testStreamFlowControl(Handler<SQLRowStream> initHandler, Handler<SQLRowStream> dataHandler) {
        String sql = "SELECT ID, FNAME, LNAME FROM select_table ORDER BY ID";
        AtomicInteger cnt = new AtomicInteger(0);
        long[] t = new long[]{0L, 0L};
        this.connection().queryStream(sql, this.onSuccess(res -> {
            res.handler(row -> {
                t[cnt.getAndIncrement()] = System.currentTimeMillis();
                dataHandler.handle(res);
            }).endHandler(v -> {
                this.assertEquals(2L, cnt.get());
                this.assertTrue(t[1] - t[0] >= 1000L);
                this.testComplete();
            }).exceptionHandler(t0 -> this.fail((Throwable)t0));
            initHandler.handle(res);
        }));
        this.await();
    }

    @Test
    public void testBigStream() {
        String sql = "SELECT * FROM big_table";
        AtomicInteger cnt = new AtomicInteger(0);
        this.connection().queryStream(sql, this.onSuccess(res -> res.resultSetClosedHandler(v -> res.moreResults()).handler(row -> cnt.incrementAndGet()).endHandler(v -> {
            this.assertEquals(200L, cnt.get());
            this.testComplete();
        }).exceptionHandler(t -> this.fail((Throwable)t))));
        this.await();
    }

    @Test
    public void testStreamColumnResolution() {
        String sql = "SELECT ID, FNAME, LNAME FROM select_table ORDER BY ID";
        AtomicInteger cnt = new AtomicInteger(0);
        this.connection().queryStream(sql, this.onSuccess(res -> res.handler(row -> {
            this.assertEquals("doe", row.getString(res.column("lname")));
            cnt.incrementAndGet();
        }).endHandler(v -> {
            this.assertEquals(2L, cnt.get());
            this.testComplete();
        }).exceptionHandler(t -> this.fail((Throwable)t))));
        this.await();
    }

    @Test
    public void testStreamGetColumns() {
        String sql = "SELECT ID, FNAME, LNAME FROM select_table ORDER BY ID";
        this.connection().queryStream(sql, this.onSuccess(res -> {
            this.assertEquals(Arrays.asList("ID", "FNAME", "LNAME"), res.columns());
            try {
                res.columns().add("durp!");
                this.fail();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testSelectWithParameters() {
        String sql = "SELECT ID, FNAME, LNAME FROM select_table WHERE fname = ?";
        this.connection().queryWithParams(sql, new JsonArray().add("john"), this.onSuccess(resultSet -> {
            this.assertNotNull(resultSet);
            this.assertEquals(1L, resultSet.getResults().size());
            this.assertEquals("ID", resultSet.getColumnNames().get(0));
            this.assertEquals("FNAME", resultSet.getColumnNames().get(1));
            this.assertEquals("LNAME", resultSet.getColumnNames().get(2));
            JsonArray result0 = (JsonArray)resultSet.getResults().get(0);
            this.assertEquals(1L, result0.getInteger(0).intValue());
            this.assertEquals("john", result0.getString(1));
            this.assertEquals("doe", result0.getString(2));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testSelectWithLabels() {
        String sql = "SELECT ID as \"IdLabel\", FNAME as \"first_name\", LNAME as \"LAST.NAME\" FROM select_table WHERE fname = ?";
        this.connection().queryWithParams(sql, new JsonArray().add("john"), this.onSuccess(resultSet -> {
            this.assertNotNull(resultSet);
            this.assertEquals(1L, resultSet.getResults().size());
            this.assertEquals("IdLabel", resultSet.getColumnNames().get(0));
            this.assertEquals("first_name", resultSet.getColumnNames().get(1));
            this.assertEquals("LAST.NAME", resultSet.getColumnNames().get(2));
            JsonArray result0 = (JsonArray)resultSet.getResults().get(0);
            this.assertEquals(1L, result0.getInteger(0).intValue());
            this.assertEquals("john", result0.getString(1));
            this.assertEquals("doe", result0.getString(2));
            JsonObject row0 = (JsonObject)resultSet.getRows().get(0);
            this.assertEquals(1L, row0.getInteger("IdLabel").intValue());
            this.assertEquals("john", row0.getString("first_name"));
            this.assertEquals("doe", row0.getString("LAST.NAME"));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testSelectTx() {
        String sql = "INSERT INTO insert_table VALUES (?, ?, ?, ?);";
        JsonArray params = new JsonArray().addNull().add("smith").add("john").add("2003-03-03");
        this.client.getConnection(this.onSuccess(conn -> {
            this.assertNotNull(conn);
            conn.setAutoCommit(false, this.onSuccess(v -> conn.setOptions(new SQLOptions().setAutoGeneratedKeys(true)).updateWithParams(sql, params, this.onSuccess(updateResult -> {
                this.assertUpdate((UpdateResult)updateResult, 1);
                int id = updateResult.getKeys().getInteger(0);
                conn.queryWithParams("SELECT LNAME FROM insert_table WHERE id = ?", new JsonArray().add(Integer.valueOf(id)), this.onSuccess(resultSet -> {
                    this.assertFalse(resultSet.getResults().isEmpty());
                    this.assertEquals("smith", ((JsonArray)resultSet.getResults().get(0)).getString(0));
                    this.testComplete();
                }));
            }))));
        }));
        this.await();
    }

    @Test
    public void testInvalidSelect() {
        JDBCClientTest.setLogLevel(AbstractJDBCAction.class.getName(), Level.SEVERE);
        String sql = "SELECT FROM WHERE FOO BAR";
        this.connection().query(sql, this.onFailure(t -> {
            this.assertNotNull(t);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testInsert() {
        String sql = "INSERT INTO insert_table VALUES (null, 'doe', 'john', '2001-01-01');";
        this.connection().update(sql, this.onSuccess(result -> {
            this.assertUpdate((UpdateResult)result, 1);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testNaturalInsert() {
        String sql = "INSERT INTO insert_table2 VALUES (1, 'doe', 'john', '2001-01-01');";
        this.connection().update(sql, this.onSuccess(result -> {
            this.assertUpdate((UpdateResult)result, 1);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testInsertWithParameters() {
        TimeZone tz = TimeZone.getDefault();
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        SQLConnection conn = this.connection();
        String sql = "INSERT INTO insert_table VALUES (?, ?, ?, ?);";
        JsonArray params = new JsonArray().addNull().add("doe").add("jane").add("2002-02-02");
        conn.setOptions(new SQLOptions().setAutoGeneratedKeys(true)).updateWithParams(sql, params, this.onSuccess(result -> {
            this.assertUpdate((UpdateResult)result, 1);
            int id = result.getKeys().getInteger(0);
            conn.queryWithParams("SElECT DOB FROM insert_table WHERE id=?;", new JsonArray().add(Integer.valueOf(id)), this.onSuccess(resultSet -> {
                this.assertNotNull(resultSet);
                this.assertEquals(1L, resultSet.getResults().size());
                this.assertEquals("2002-02-02", ((JsonArray)resultSet.getResults().get(0)).getString(0));
                TimeZone.setDefault(tz);
                this.testComplete();
            }));
        }));
        this.await();
    }

    @Test
    public void testUpdate() {
        SQLConnection conn = this.connection();
        String sql = "UPDATE update_table SET fname='jane' WHERE id = 1";
        conn.update(sql, this.onSuccess(updated -> {
            this.assertUpdate((UpdateResult)updated, 1);
            conn.query("SELECT fname FROM update_table WHERE id = 1", this.onSuccess(resultSet -> {
                this.assertNotNull(resultSet);
                this.assertEquals(1L, resultSet.getResults().size());
                this.assertEquals("jane", ((JsonArray)resultSet.getResults().get(0)).getString(0));
                this.testComplete();
            }));
        }));
        this.await();
    }

    @Test
    public void testUpdateWithParams() {
        SQLConnection conn = this.connection();
        String sql = "UPDATE update_table SET fname = ? WHERE id = ?";
        JsonArray params = new JsonArray().add("bob").add(Integer.valueOf(1));
        conn.updateWithParams(sql, params, this.onSuccess(result -> {
            this.assertUpdate((UpdateResult)result, 1);
            conn.query("SELECT fname FROM update_table WHERE id = 1", this.onSuccess(resultSet -> {
                this.assertNotNull(resultSet);
                this.assertEquals(1L, resultSet.getResults().size());
                this.assertEquals("bob", ((JsonArray)resultSet.getResults().get(0)).getString(0));
                this.testComplete();
            }));
        }));
        this.await();
    }

    @Test
    public void testUpdateNoMatch() {
        SQLConnection conn = this.connection();
        String sql = "UPDATE update_table SET fname='jane' WHERE id = -231";
        conn.update(sql, this.onSuccess(result -> {
            this.assertUpdate((UpdateResult)result, 0);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testDelete() {
        String sql = "DELETE FROM delete_table WHERE id = 1;";
        this.connection().update(sql, this.onSuccess(result -> {
            this.assertNotNull(result);
            this.assertEquals(1L, result.getUpdated());
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testDeleteWithParams() {
        String sql = "DELETE FROM delete_table WHERE id = ?;";
        JsonArray params = new JsonArray().add(Integer.valueOf(2));
        this.connection().updateWithParams(sql, params, this.onSuccess(result -> {
            this.assertNotNull(result);
            this.assertEquals(1L, result.getUpdated());
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testClose() throws Exception {
        this.client.getConnection(this.onSuccess(conn -> conn.query("SELECT 1 FROM select_table", this.onSuccess(results -> {
            this.assertNotNull(results);
            conn.close(this.onSuccess(v -> this.testComplete()));
        }))));
        this.await();
    }

    @Test
    public void testCloseThenQuery() throws Exception {
        this.client.getConnection(this.onSuccess(conn -> conn.close(this.onSuccess(v -> conn.query("SELECT 1 FROM select_table", this.onFailure(t -> {
            this.assertNotNull(t);
            this.testComplete();
        }))))));
        this.await();
    }

    @Test
    public void testCommit() throws Exception {
        this.testTx(3, true);
    }

    @Test
    public void testRollback() throws Exception {
        this.testTx(5, false);
    }

    @Test
    public void testBlob() {
        String sql = "SELECT b FROM blob_table";
        this.connection().query(sql, this.onSuccess(resultSet -> {
            this.assertNotNull(resultSet);
            this.assertEquals(1L, resultSet.getResults().size());
            this.assertNull(((JsonArray)resultSet.getResults().get(0)).getBinary(0));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testClob() {
        String sql = "SELECT c FROM blob_table";
        this.connection().query(sql, this.onSuccess(resultSet -> {
            this.assertNotNull(resultSet);
            this.assertEquals(1L, resultSet.getResults().size());
            this.assertNotNull(((JsonArray)resultSet.getResults().get(0)).getString(0));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testArray() {
        String sql = "SELECT a FROM blob_table";
        this.connection().query(sql, this.onSuccess(resultSet -> {
            this.assertNotNull(resultSet);
            this.assertEquals(1L, resultSet.getResults().size());
            this.assertNotNull(((JsonArray)resultSet.getResults().get(0)).getJsonArray(0));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testWorkerPerConnection() {
        int numConns = 4;
        ArrayList<SQLConnection> conns = new ArrayList<SQLConnection>();
        for (int i = 0; i < numConns; ++i) {
            conns.add(this.connection());
        }
        AtomicInteger count = new AtomicInteger();
        Context context = this.vertx.getOrCreateContext();
        context.runOnContext(v -> {
            for (SQLConnection conn : conns) {
                conn.setAutoCommit(false, this.onSuccess(ar1 -> conn.execute("LOCK TABLE insert_table WRITE", this.onSuccess(ar2 -> {
                    String sql = "INSERT INTO insert_table VALUES (null, 'doe', 'john', '2001-01-01');";
                    conn.update(sql, this.onSuccess(res3 -> conn.commit(this.onSuccess(committed -> conn.close(this.onSuccess(closed -> {
                        if (count.incrementAndGet() == numConns) {
                            this.testComplete();
                        }
                    }))))));
                }))));
            }
        });
        this.await();
    }

    @Test
    public void testSameContext() {
        Context ctx = this.vertx.getOrCreateContext();
        SQLConnection conn = this.connection(ctx);
        conn.query("SELECT a FROM blob_table", this.onSuccess(rs -> {
            this.assertSame(Vertx.currentContext(), ctx);
            this.testComplete();
        }));
        this.await();
    }

    private void testTx(int inserts, boolean commit) throws Exception {
        String sql = "INSERT INTO insert_table VALUES (?, ?, ?, ?);";
        JsonArray params = new JsonArray().addNull().add("smith").add("john").add("2003-03-03");
        CopyOnWriteArrayList insertIds = new CopyOnWriteArrayList();
        CountDownLatch latch = new CountDownLatch(inserts);
        AtomicReference connRef = new AtomicReference();
        this.client.getConnection(this.onSuccess(conn -> {
            this.assertNotNull(conn);
            connRef.set(conn);
            conn.setAutoCommit(false, this.onSuccess(v -> {
                for (int i = 0; i < inserts; ++i) {
                    conn.setOptions(new SQLOptions().setAutoGeneratedKeys(true)).updateWithParams(sql, params, this.onSuccess(result -> {
                        this.assertUpdate((UpdateResult)result, 1);
                        int id = result.getKeys().getInteger(0);
                        insertIds.add(id);
                        latch.countDown();
                    }));
                }
            }));
        }));
        this.awaitLatch(latch);
        StringBuilder selectSql = new StringBuilder("SELECT * FROM insert_table WHERE");
        JsonArray selectParams = new JsonArray();
        for (int i = 0; i < insertIds.size(); ++i) {
            selectParams.add((Integer)insertIds.get(i));
            if (i == 0) {
                selectSql.append(" id = ?");
                continue;
            }
            selectSql.append(" OR id = ?");
        }
        SQLConnection conn2 = (SQLConnection)connRef.get();
        if (commit) {
            conn2.commit(this.onSuccess(v -> this.client.getConnection(this.onSuccess(newconn -> newconn.queryWithParams(selectSql.toString(), selectParams, this.onSuccess(resultSet -> {
                this.assertEquals(inserts, resultSet.getResults().size());
                this.testComplete();
            }))))));
        } else {
            conn2.rollback(this.onSuccess(v -> this.client.getConnection(this.onSuccess(newconn -> newconn.queryWithParams(selectSql.toString(), selectParams, this.onSuccess(resultSet -> {
                this.assertTrue(resultSet.getResults().isEmpty());
                this.testComplete();
            }))))));
        }
        this.await();
    }

    protected SQLConnection connection() {
        return this.connection(this.vertx.getOrCreateContext());
    }

    protected SQLConnection connection(Context context) {
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference ref = new AtomicReference();
        context.runOnContext(v -> this.client.getConnection(this.onSuccess(conn -> {
            ref.set(conn);
            latch.countDown();
        })));
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return (SQLConnection)ref.get();
    }
}

