/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jdbc;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.sql.UpdateResult;
import io.vertx.test.core.VertxTestBase;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.BeforeClass;

public abstract class JDBCClientTestBase
extends VertxTestBase {
    private static final List<String> SQL = new ArrayList<String>();

    @BeforeClass
    public static void createDb() throws Exception {
        Connection conn = DriverManager.getConnection(JDBCClientTestBase.config().getString("url"));
        for (String sql : SQL) {
            conn.createStatement().execute(sql);
        }
    }

    protected static JsonObject config() {
        return new JsonObject().put("url", "jdbc:hsqldb:mem:test?shutdown=true").put("driver_class", "org.hsqldb.jdbcDriver");
    }

    protected void assertUpdate(UpdateResult result, int updated) {
        this.assertUpdate(result, updated, false);
    }

    protected void assertUpdate(UpdateResult result, int updated, boolean generatedKeys) {
        this.assertNotNull(result);
        this.assertEquals(updated, result.getUpdated());
        if (generatedKeys) {
            JsonArray keys = result.getKeys();
            this.assertNotNull(keys);
            this.assertEquals(updated, keys.size());
            HashSet<Integer> numbers = new HashSet<Integer>();
            for (int i = 0; i < updated; ++i) {
                this.assertTrue(keys.getValue(i) instanceof Integer);
                this.assertTrue(numbers.add(i));
            }
        }
    }

    protected static void setLogLevel(String name, Level level) {
        Logger logger = Logger.getLogger(name);
        if (logger != null) {
            logger.setLevel(level);
        }
    }

    static {
        System.setProperty("textdb.allow_full_path", "true");
        SQL.add("drop table if exists select_table;");
        SQL.add("drop table if exists insert_table;");
        SQL.add("drop table if exists insert_table2;");
        SQL.add("drop table if exists update_table;");
        SQL.add("drop table if exists delete_table;");
        SQL.add("drop table if exists blob_table;");
        SQL.add("drop table if exists big_table;");
        SQL.add("create table select_table (id int, lname varchar(255), fname varchar(255) );");
        SQL.add("insert into select_table values (1, 'doe', 'john');");
        SQL.add("insert into select_table values (2, 'doe', 'jane');");
        SQL.add("create table insert_table (id int generated by default as identity (start with 1 increment by 1) not null, lname varchar(255), fname varchar(255), dob date );");
        SQL.add("create table insert_table2 (id int not null, lname varchar(255), fname varchar(255), dob date );");
        SQL.add("create table update_table (id int, lname varchar(255), fname varchar(255), dob date );");
        SQL.add("insert into update_table values (1, 'doe', 'john', '2001-01-01');");
        SQL.add("create table delete_table (id int, lname varchar(255), fname varchar(255), dob date );");
        SQL.add("insert into delete_table values (1, 'doe', 'john', '2001-01-01');");
        SQL.add("insert into delete_table values (2, 'doe', 'jane', '2002-02-02');");
        SQL.add("create table blob_table (b blob, c clob, a int array default array[]);");
        SQL.add("insert into blob_table (b, c, a) values (null, convert('Hello', clob),  ARRAY[1,2,3])");
        SQL.add("create table big_table(id int primary key, name varchar(255))");
        for (int i = 0; i < 200; ++i) {
            SQL.add("insert into big_table values(" + i + ", 'Hello')");
        }
    }
}

