/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jdbc;

import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.jdbc.ConfigFactory;
import io.vertx.ext.jdbc.JDBCClient;
import io.vertx.ext.sql.SQLClient;
import io.vertx.ext.sql.SQLConnection;
import io.vertx.test.core.VertxTestBase;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class JDBCCustomTypesTest
extends VertxTestBase {
    private static final List<String> SQL = new ArrayList<String>();
    private JsonObject config;
    private SQLClient client;

    @Before
    public void setUp() throws Exception {
        this.config = ConfigFactory.createConfigForH2();
        try (Connection conn = DriverManager.getConnection(this.config.getString("url"));){
            for (String sql : SQL) {
                Statement statement = conn.createStatement();
                Throwable throwable = null;
                try {
                    statement.execute(sql);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (statement == null) continue;
                    if (throwable != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    statement.close();
                }
            }
        }
        super.setUp();
        this.client = JDBCClient.create((Vertx)this.vertx, (JsonObject)this.config);
    }

    @After
    public void after() throws Exception {
        this.client.close();
        try (Connection conn = DriverManager.getConnection(this.config.getString("url"));
             Statement statement = conn.createStatement();){
            statement.execute("SHUTDOWN");
        }
        super.after();
    }

    @Test
    public void testCustom() {
        String sql = "SELECT u FROM t";
        this.connection().query(sql, this.onSuccess(resultSet -> {
            this.assertNotNull(resultSet);
            this.assertEquals(1L, resultSet.getResults().size());
            this.assertNotNull(((JsonArray)resultSet.getResults().get(0)).getString(0));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testCustomInsert() {
        String sql = "INSERT INTO t (u, t, d, ts) VALUES (?, ?, ?, ?)";
        String uuid = UUID.randomUUID().toString();
        SQLConnection conn = this.connection();
        conn.setAutoCommit(false, tx -> {
            if (tx.succeeded()) {
                conn.updateWithParams(sql, new JsonArray().add(uuid).add("09:00:00").add("2015-03-16").add(Instant.now()), this.onSuccess(resultSet -> this.testComplete()));
            }
        });
        this.await();
    }

    private SQLConnection connection() {
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference ref = new AtomicReference();
        this.client.getConnection(this.onSuccess(conn -> {
            ref.set(conn);
            latch.countDown();
        }));
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return (SQLConnection)ref.get();
    }

    static {
        SQL.add("drop table if exists t");
        SQL.add("create table t (u UUID, d DATE, t TIME, ts TIMESTAMP)");
        SQL.add("insert into t (u) values (random_uuid())");
    }
}

