/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jdbc;

import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.jdbc.JDBCClient;
import io.vertx.ext.sql.SQLClient;
import io.vertx.ext.sql.SQLConnection;
import io.vertx.test.core.VertxTestBase;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class JDBCQueryTimeoutTest
extends VertxTestBase {
    protected SQLClient client;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.client = JDBCClient.create((Vertx)this.vertx, (JsonObject)JDBCQueryTimeoutTest.config());
    }

    @After
    public void after() throws Exception {
        this.client.close();
        super.after();
    }

    protected static JsonObject config() {
        return new JsonObject().put("url", "jdbc:derby:memory:myDB2;create=true").put("driver_class", "org.apache.derby.jdbc.EmbeddedDriver");
    }

    @Test
    public void testQueryTimeout() {
        String sql = "{call NAP(1) + NAP(1) + NAP(1) + NAP(1) + NAP(1)}";
        SQLConnection conn = this.connection();
        conn.execute("CREATE FUNCTION NAP() returns INT PARAMETER STYLE JAVA reads sql data language JAVA EXTERNAL NAME 'io.vertx.ext.jdbc.Functions.nap'", this.onSuccess(res -> conn.setQueryTimeout(1).call(sql, this.onFailure(resultSet -> {
            this.assertNotNull(resultSet);
            this.testComplete();
        }))));
        this.await();
    }

    @Test
    public void testMultiSelect() {
        String sql = "{ call MS() }";
        SQLConnection conn = this.connection();
        conn.execute("CREATE PROCEDURE MS() PARAMETER STYLE JAVA LANGUAGE JAVA READS SQL DATA DYNAMIC RESULT SETS 2 EXTERNAL NAME 'io.vertx.ext.jdbc.Functions.multiSelect'", this.onSuccess(res -> conn.call(sql, this.onSuccess(resultSet -> {
            this.assertNotNull(resultSet);
            this.assertNotNull(resultSet.getNext());
            this.testComplete();
        }))));
        this.await();
    }

    private SQLConnection connection() {
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference ref = new AtomicReference();
        this.client.getConnection(this.onSuccess(conn -> {
            ref.set(conn);
            latch.countDown();
        }));
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return (SQLConnection)ref.get();
    }
}

