/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jdbc;

import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.jdbc.JDBCClient;
import io.vertx.ext.sql.SQLClient;
import io.vertx.ext.sql.SQLConnection;
import io.vertx.test.core.VertxTestBase;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class JDBCStoredProcedure2Test
extends VertxTestBase {
    protected SQLClient client;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.client = JDBCClient.create((Vertx)this.vertx, (JsonObject)JDBCStoredProcedure2Test.config());
    }

    @After
    public void after() throws Exception {
        this.client.close();
        super.after();
    }

    protected static JsonObject config() {
        return new JsonObject().put("url", "jdbc:mysql://localhost/test").put("driver_class", "com.mysql.jdbc.Driver").put("user", "root").put("password", "mypassword");
    }

    @Test
    @Ignore
    public void testStoredProcedure1() {
        this.connection().callWithParams("{call proc_test(?, ?)}", new JsonArray().add("zepinos"), new JsonArray().addNull().add("VARCHAR"), this.onSuccess(resultSet -> {
            this.assertNotNull(resultSet);
            this.assertEquals(1L, resultSet.getResults().size());
            this.assertEquals("zepinos!!!", resultSet.getOutput().getString(1));
            this.testComplete();
        }));
        this.await();
    }

    private SQLConnection connection() {
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference ref = new AtomicReference();
        this.client.getConnection(this.onSuccess(conn -> {
            ref.set(conn);
            latch.countDown();
        }));
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return (SQLConnection)ref.get();
    }
}

