/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jdbc;

import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.jdbc.JDBCClient;
import io.vertx.ext.sql.SQLClient;
import io.vertx.ext.sql.SQLConnection;
import io.vertx.ext.sql.SQLOptions;
import io.vertx.ext.sql.UpdateResult;
import io.vertx.test.core.VertxTestBase;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class JDBCTypesTestBase
extends VertxTestBase {
    protected SQLClient client;
    private static final List<String> SQL = new ArrayList<String>();

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.client = JDBCClient.create((Vertx)this.vertx, (JsonObject)JDBCTypesTestBase.config());
    }

    @After
    public void after() throws Exception {
        this.client.close();
        super.after();
    }

    @BeforeClass
    public static void createDb() throws Exception {
        Connection conn = DriverManager.getConnection(JDBCTypesTestBase.config().getString("url"));
        for (String sql : SQL) {
            conn.createStatement().execute(sql);
        }
    }

    protected static JsonObject config() {
        return new JsonObject().put("url", "jdbc:derby:memory:myDB2;create=true").put("driver_class", "org.apache.derby.jdbc.EmbeddedDriver");
    }

    @Test
    public void testInsertWithNullParameters() {
        SQLConnection conn = this.connection();
        String sql = "INSERT INTO insert_table (lname, fname, dob) VALUES (?, ?, ?)";
        JsonArray params = new JsonArray().addNull().addNull().add("2002-02-02");
        conn.setOptions(new SQLOptions().setAutoGeneratedKeys(true)).updateWithParams(sql, params, this.onSuccess(result -> {
            this.assertUpdate((UpdateResult)result, 1);
            int id = result.getKeys().getInteger(0);
            conn.queryWithParams("SElECT DOB FROM insert_table WHERE id=?", new JsonArray().add(Integer.valueOf(id)), this.onSuccess(resultSet -> {
                this.assertNotNull(resultSet);
                this.assertEquals(1L, resultSet.getResults().size());
                System.out.println(((JsonArray)resultSet.getResults().get(0)).getValue(0));
                this.testComplete();
            }));
        }));
        this.await();
    }

    @Test
    public void testInsertUpdateNoIdentity() {
        SQLConnection conn = this.connection();
        String insertsql = "INSERT INTO insert_tableNoIdentity (id, lname, fname, dob) VALUES (?, ?, ?, ?)";
        JsonArray insertparams = new JsonArray().add(Integer.valueOf(1)).add("LastName1").addNull().add("2002-02-02");
        conn.updateWithParams(insertsql, insertparams, this.onSuccess(insertResultSet -> {
            this.assertUpdate((UpdateResult)insertResultSet, 1);
            int insertid = insertResultSet.getKeys().isEmpty() ? 1 : insertResultSet.getKeys().getInteger(0);
            conn.queryWithParams("SElECT lname FROM insert_tableNoIdentity WHERE id=?", new JsonArray().add(Integer.valueOf(1)), this.onSuccess(insertQueryResultSet -> {
                this.assertNotNull(insertQueryResultSet);
                this.assertEquals(1L, insertQueryResultSet.getResults().size());
                this.assertEquals("LastName1", ((JsonArray)insertQueryResultSet.getResults().get(0)).getValue(0));
                System.out.println("testInsertUpdateNoIdentity: insert: " + ((JsonArray)insertQueryResultSet.getResults().get(0)).getValue(0));
                String updSql = "UPDATE insert_tableNoIdentity SET lname=? WHERE id=?";
                JsonArray updParams = new JsonArray().add("LastName2").add(Integer.valueOf(insertid));
                conn.updateWithParams(updSql, updParams, this.onSuccess(updateResultSet -> {
                    this.assertUpdate((UpdateResult)updateResultSet, 1);
                    int updateid = updateResultSet.getKeys().isEmpty() ? 1 : updateResultSet.getKeys().getInteger(0);
                    conn.queryWithParams("SElECT lname FROM insert_tableNoIdentity WHERE id=?", new JsonArray().add(Integer.valueOf(updateid)), this.onSuccess(updateQueryResultSet -> {
                        this.assertNotNull(updateQueryResultSet);
                        this.assertEquals(1L, updateQueryResultSet.getResults().size());
                        this.assertEquals("LastName2", ((JsonArray)updateQueryResultSet.getResults().get(0)).getValue(0));
                        System.out.println("testInsertUpdateNoIdentity: update: " + ((JsonArray)updateQueryResultSet.getResults().get(0)).getValue(0));
                        this.testComplete();
                    }));
                }));
            }));
        }));
        this.await();
    }

    private void assertUpdate(UpdateResult result, int updated) {
        this.assertUpdate(result, updated, false);
    }

    private void assertUpdate(UpdateResult result, int updated, boolean generatedKeys) {
        this.assertNotNull(result);
        this.assertEquals(updated, result.getUpdated());
        if (generatedKeys) {
            JsonArray keys = result.getKeys();
            this.assertNotNull(keys);
            this.assertEquals(updated, keys.size());
            HashSet<Integer> numbers = new HashSet<Integer>();
            for (int i = 0; i < updated; ++i) {
                this.assertTrue(keys.getValue(i) instanceof Integer);
                this.assertTrue(numbers.add(i));
            }
        }
    }

    private SQLConnection connection() {
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference ref = new AtomicReference();
        this.client.getConnection(this.onSuccess(conn -> {
            ref.set(conn);
            latch.countDown();
        }));
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return (SQLConnection)ref.get();
    }

    static {
        SQL.add("create table insert_table (id int not null primary key generated always as identity (START WITH 1, INCREMENT BY 1), lname varchar(255), fname varchar(255), dob date )");
        SQL.add("create table insert_tableNoIdentity (id int not null primary key, lname varchar(255), fname varchar(255), dob date )");
    }
}

