/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jdbc;

import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.core.metrics.MetricsOptions;
import io.vertx.core.spi.VertxMetricsFactory;
import io.vertx.ext.jdbc.JDBCClient;
import io.vertx.ext.sql.SQLClient;
import io.vertx.test.core.VertxTestBase;
import io.vertx.test.fakemetrics.FakeMetricsFactory;
import io.vertx.test.fakemetrics.FakePoolMetrics;
import java.util.concurrent.CountDownLatch;
import org.h2.tools.Server;
import org.junit.After;
import org.junit.Test;

public class PoolTest
extends VertxTestBase {
    Server server;
    SQLClient client;

    public void setUp() throws Exception {
        this.server = Server.createTcpServer((String[])new String[]{"-tcp"}).start();
        super.setUp();
    }

    protected VertxOptions getOptions() {
        MetricsOptions options = new MetricsOptions().setEnabled(true);
        options.setFactory((VertxMetricsFactory)new FakeMetricsFactory());
        return new VertxOptions().setMetricsOptions(options);
    }

    @Test(timeout=5000L)
    public void testUseAvailableResources() {
        int poolSize = 3;
        this.waitFor(poolSize + 1);
        JsonObject config = new JsonObject().put("url", "jdbc:h2:tcp://localhost/mem:test").put("driver_class", "org.h2.Driver").put("initial_pool_size", Integer.valueOf(poolSize)).put("max_pool_size", Integer.valueOf(poolSize));
        this.client = JDBCClient.createShared((Vertx)this.vertx, (JsonObject)config);
        this.vertx.setPeriodic(10L, timerId -> {
            FakePoolMetrics metrics = this.getMetrics();
            if (metrics != null && poolSize == metrics.numberOfRunningTasks()) {
                this.vertx.cancelTimer(timerId.longValue());
                this.complete();
            }
        });
        this.client.query("CREATE ALIAS SLEEP FOR \"io.vertx.ext.jdbc.PoolTest.sleep\";", this.onSuccess(def -> {
            for (int i = 0; i < poolSize; ++i) {
                this.client.query("SELECT SLEEP(500)", this.onSuccess(rs -> this.complete()));
            }
        }));
        this.await();
    }

    public static int sleep(int howLong) {
        try {
            Thread.sleep(howLong);
        }
        catch (InterruptedException e) {
            return -1;
        }
        return howLong;
    }

    @After
    public void after() throws Exception {
        if (this.client != null) {
            CountDownLatch latch = new CountDownLatch(1);
            this.client.close(ar -> latch.countDown());
            this.awaitLatch(latch);
        }
        super.after();
        if (this.server != null) {
            this.server.stop();
        }
    }

    private FakePoolMetrics getMetrics() {
        return (FakePoolMetrics)FakePoolMetrics.getPoolMetrics().get("DEFAULT_DS");
    }
}

