/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jdbc;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.core.shareddata.LocalMap;
import io.vertx.ext.jdbc.JDBCClient;
import io.vertx.ext.sql.SQLClient;
import io.vertx.test.core.VertxTestBase;
import org.junit.Test;

public class RefCountTest
extends VertxTestBase {
    private LocalMap<String, Object> map;

    public void setUp() throws Exception {
        super.setUp();
        this.map = this.vertx.sharedData().getLocalMap("__vertx.JDBCClient.datasources");
    }

    @Test
    public void testNonShared() {
        JsonObject config = new JsonObject();
        JDBCClient client1 = JDBCClient.create((Vertx)this.vertx, (JsonObject)config);
        this.assertEquals(1L, this.map.size());
        JDBCClient client2 = JDBCClient.create((Vertx)this.vertx, (JsonObject)config);
        this.assertEquals(2L, this.map.size());
        JDBCClient client3 = JDBCClient.create((Vertx)this.vertx, (JsonObject)config);
        this.assertEquals(3L, this.map.size());
        this.close((SQLClient)client1, 2).compose(arg_0 -> this.lambda$testNonShared$0((SQLClient)client2, arg_0)).compose(arg_0 -> this.lambda$testNonShared$1((SQLClient)client3, arg_0)).setHandler(this.onSuccess(v -> this.testComplete()));
        this.await();
    }

    @Test
    public void testSharedDefault() throws Exception {
        JsonObject config = new JsonObject();
        JDBCClient client1 = JDBCClient.createShared((Vertx)this.vertx, (JsonObject)config);
        this.assertEquals(1L, this.map.size());
        JDBCClient client2 = JDBCClient.createShared((Vertx)this.vertx, (JsonObject)config);
        this.assertEquals(1L, this.map.size());
        JDBCClient client3 = JDBCClient.createShared((Vertx)this.vertx, (JsonObject)config);
        this.assertEquals(1L, this.map.size());
        this.close((SQLClient)client1, 1).compose(arg_0 -> this.lambda$testSharedDefault$3((SQLClient)client2, arg_0)).compose(arg_0 -> this.lambda$testSharedDefault$4((SQLClient)client3, arg_0)).setHandler(this.onSuccess(v -> this.testComplete()));
        this.await();
    }

    @Test
    public void testSharedNamed() throws Exception {
        JsonObject config = new JsonObject();
        JDBCClient client1 = JDBCClient.createShared((Vertx)this.vertx, (JsonObject)config, (String)"ds1");
        this.assertEquals(1L, this.map.size());
        JDBCClient client2 = JDBCClient.createShared((Vertx)this.vertx, (JsonObject)config, (String)"ds1");
        this.assertEquals(1L, this.map.size());
        JDBCClient client3 = JDBCClient.createShared((Vertx)this.vertx, (JsonObject)config, (String)"ds1");
        this.assertEquals(1L, this.map.size());
        JDBCClient client4 = JDBCClient.createShared((Vertx)this.vertx, (JsonObject)config, (String)"ds2");
        this.assertEquals(2L, this.map.size());
        JDBCClient client5 = JDBCClient.createShared((Vertx)this.vertx, (JsonObject)config, (String)"ds2");
        this.assertEquals(2L, this.map.size());
        JDBCClient client6 = JDBCClient.createShared((Vertx)this.vertx, (JsonObject)config, (String)"ds2");
        this.assertEquals(2L, this.map.size());
        this.close((SQLClient)client1, 2).compose(arg_0 -> this.lambda$testSharedNamed$6((SQLClient)client2, arg_0)).compose(arg_0 -> this.lambda$testSharedNamed$7((SQLClient)client3, arg_0)).compose(arg_0 -> this.lambda$testSharedNamed$8((SQLClient)client4, arg_0)).compose(arg_0 -> this.lambda$testSharedNamed$9((SQLClient)client5, arg_0)).compose(arg_0 -> this.lambda$testSharedNamed$10((SQLClient)client6, arg_0)).setHandler(this.onSuccess(v -> this.testComplete()));
        this.await();
    }

    private Future<Void> close(SQLClient client, int expectedMapSize) {
        Promise promise = Promise.promise();
        client.close((Handler)promise);
        return promise.future().compose(v -> {
            this.assertEquals(expectedMapSize, this.map.size());
            return Future.succeededFuture((Object)v);
        });
    }

    private /* synthetic */ Future lambda$testSharedNamed$10(SQLClient client6, Void v) {
        return this.close(client6, 0);
    }

    private /* synthetic */ Future lambda$testSharedNamed$9(SQLClient client5, Void v) {
        return this.close(client5, 1);
    }

    private /* synthetic */ Future lambda$testSharedNamed$8(SQLClient client4, Void v) {
        return this.close(client4, 1);
    }

    private /* synthetic */ Future lambda$testSharedNamed$7(SQLClient client3, Void v) {
        return this.close(client3, 1);
    }

    private /* synthetic */ Future lambda$testSharedNamed$6(SQLClient client2, Void v) {
        return this.close(client2, 2);
    }

    private /* synthetic */ Future lambda$testSharedDefault$4(SQLClient client3, Void v) {
        return this.close(client3, 0);
    }

    private /* synthetic */ Future lambda$testSharedDefault$3(SQLClient client2, Void v) {
        return this.close(client2, 1);
    }

    private /* synthetic */ Future lambda$testNonShared$1(SQLClient client3, Void v) {
        return this.close(client3, 0);
    }

    private /* synthetic */ Future lambda$testNonShared$0(SQLClient client2, Void v) {
        return this.close(client2, 1);
    }
}

