/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jdbc.impl.actions;

import io.vertx.core.json.JsonObject;
import io.vertx.ext.jdbc.impl.actions.JDBCStatementHelper;
import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class OptimisticCastTest {
    private JDBCStatementHelper helper;
    private String value;
    private String expectedType;

    @Parameterized.Parameters
    public static Collection<Object[]> generateData() {
        return Arrays.asList({"16:00:00", "java.sql.Time", null}, {"16:00:00", "java.lang.String", new JsonObject().put("castTime", Boolean.valueOf(false))}, {"2016-03-16", "java.sql.Date", null}, {"2016-03-16", "java.lang.String", new JsonObject().put("castDate", Boolean.valueOf(false))}, {"2016-03-16T16:00:00Z", "java.sql.Timestamp", null}, {"2016-03-16T16:00:00Z", "java.lang.String", new JsonObject().put("castDatetime", Boolean.valueOf(false))}, {"f47ac10b-58cc-4372-a567-0e02b2c3d479", "java.util.UUID", new JsonObject().put("castUUID", Boolean.valueOf(true))}, {"f47ac10b-58cc-4372-a567-0e02b2c3d479", "java.lang.String", null}, {"2016-03-16T16:00:00", "java.lang.String", null}, {"24:00:00", "java.lang.String", null}, {"2016-00-00", "java.lang.String", null});
    }

    public OptimisticCastTest(String value, String expectedType, JsonObject config) {
        this.helper = config == null ? new JDBCStatementHelper() : new JDBCStatementHelper(config);
        this.value = value;
        this.expectedType = expectedType;
    }

    @Test
    public void testOptimisticCast() {
        Assert.assertEquals((String)this.value, (Object)this.expectedType, (Object)this.helper.optimisticCast(this.value).getClass().getName());
    }
}

