/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jdbc.impl.actions;

import io.vertx.core.json.JsonObject;
import io.vertx.ext.jdbc.impl.actions.JDBCStatementHelper;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SQLConvertTest {
    private JsonObject config = new JsonObject().put("castUUID", Boolean.valueOf(true));
    private JDBCStatementHelper helper = new JDBCStatementHelper(this.config);
    private String value;
    private Class<?> expectedSqlType;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> generateData() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        ZonedDateTime dateTime = ZonedDateTime.of(2016, 3, 16, 16, 0, 0, 0, ZoneId.of("Europe/Paris"));
        for (int i = 0; i < 4; ++i) {
            int nanos = 123 * (i == 0 ? 0 : 1) * (int)Math.pow(1000.0, i > 1 ? (double)(i - 1) : 0.0);
            params.add(new Object[]{DateTimeFormatter.ISO_INSTANT.format(dateTime.withNano(nanos)), Timestamp.class});
        }
        params.add(new Object[]{DateTimeFormatter.ISO_LOCAL_TIME.format(dateTime.withSecond(1)), Time.class});
        params.add(new Object[]{dateTime.toLocalDate().toString(), Date.class});
        params.add(new Object[]{"f47ac10b-58cc-4372-a567-0e02b2c3d479", UUID.class});
        return params;
    }

    public SQLConvertTest(String value, Class<?> expectedSqlType) {
        this.value = value;
        this.expectedSqlType = expectedSqlType;
    }

    @Test
    public void testSQLConvert() throws SQLException {
        Object cast = this.helper.optimisticCast(this.value);
        Assert.assertThat((Object)cast, (Matcher)CoreMatchers.instanceOf(this.expectedSqlType));
        Object convert = JDBCStatementHelper.convertSqlValue((Object)cast);
        Assert.assertEquals((Object)this.value, (Object)convert);
    }
}

