/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jdbc.spi.impl;

import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.jdbc.JDBCClient;
import io.vertx.ext.sql.SQLClient;
import io.vertx.test.core.VertxTestBase;
import java.sql.SQLException;
import org.hamcrest.CoreMatchers;
import org.junit.Test;

public class C3P0DataSourceProviderTest
extends VertxTestBase {
    private SQLClient client;

    protected void tearDown() throws Exception {
        this.client.close();
        super.tearDown();
    }

    private JsonObject config() {
        return new JsonObject().put("url", "jdbc:hsqldb:hsqls://zoom.zoom.zen.tld/doesnotexist").put("driver_class", "org.hsqldb.jdbcDriver");
    }

    @Test
    public void continuingConnectionAttempts() {
        this.client = JDBCClient.create((Vertx)this.vertx, (JsonObject)this.config());
        this.vertx.setTimer(2000L, res -> this.testComplete());
        this.client.getConnection(ar -> this.fail("Should not get invoked"));
        this.await();
    }

    @Test
    public void stopConnectionAttempts() {
        JsonObject config = this.config().put("acquire_retry_attempts", Integer.valueOf(1)).put("break_after_acquire_failure", Boolean.valueOf(true));
        this.client = JDBCClient.create((Vertx)this.vertx, (JsonObject)config);
        this.vertx.setTimer(2000L, res -> this.fail("Should not get invoked"));
        this.client.getConnection(this.onFailure(t -> {
            this.assertThat(t, CoreMatchers.instanceOf(SQLException.class));
            this.testComplete();
        }));
        this.await();
    }
}

