/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jdbc.spi.impl;

import io.vertx.core.json.JsonObject;
import io.vertx.ext.jdbc.spi.impl.HikariCPDataSourceProvider;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.junit.Assert;
import org.junit.Test;

public class HikariCPDataSourceProviderTest {
    @Test
    public void testCreationOfTheHikariCPDataSource() throws SQLException {
        HikariCPDataSourceProvider provider = new HikariCPDataSourceProvider();
        JsonObject configuration = new JsonObject();
        configuration.put("foo", "bar").put("jdbcUrl", "jdbc:hsqldb:mem:test?shutdown=true").put("maxLifetime", Long.valueOf(200L)).put("maximumPoolSize", Integer.valueOf(30));
        DataSource dataSource = provider.getDataSource(configuration);
        Assert.assertNotNull((Object)dataSource);
        Assert.assertNotNull((Object)dataSource.getConnection());
        Assert.assertEquals((long)30L, (long)provider.maximumPoolSize(dataSource, configuration));
        provider.close(dataSource);
    }

    @Test
    public void testCreationOfTheHikariCPDataSourceWithInteger() throws SQLException {
        HikariCPDataSourceProvider provider = new HikariCPDataSourceProvider();
        JsonObject configuration = new JsonObject();
        configuration.put("foo", "bar").put("jdbcUrl", "jdbc:hsqldb:mem:test?shutdown=true").put("maxLifetime", Integer.valueOf(200));
        DataSource dataSource = provider.getDataSource(configuration);
        Assert.assertNotNull((Object)dataSource);
        Assert.assertNotNull((Object)dataSource.getConnection());
        provider.close(dataSource);
    }

    @Test
    public void testLeakDetectionOfTheHikariCPDataSourceWithLong() throws SQLException {
        HikariCPDataSourceProvider provider = new HikariCPDataSourceProvider();
        JsonObject configuration = new JsonObject();
        configuration.put("foo", "bar").put("jdbcUrl", "jdbc:hsqldb:mem:test?shutdown=true").put("leakDetectionThreshold", Integer.valueOf(10000));
        DataSource dataSource = provider.getDataSource(configuration);
        Assert.assertNotNull((Object)dataSource);
        Assert.assertNotNull((Object)dataSource.getConnection());
        provider.close(dataSource);
    }
}

