/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen.testmodel;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.testmodel.TestDataObject;
import io.vertx.codegen.testmodel.TestEnum;
import io.vertx.codegen.testmodel.TestGenEnum;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

@DataObject
public class DataObjectWithMaps {
    Map<String, Short> shortValues = new HashMap<String, Short>();
    Map<String, Integer> integerValues = new HashMap<String, Integer>();
    Map<String, Long> longValues = new HashMap<String, Long>();
    Map<String, Float> floatValues = new HashMap<String, Float>();
    Map<String, Double> doubleValues = new HashMap<String, Double>();
    Map<String, Boolean> booleanValues = new HashMap<String, Boolean>();
    Map<String, String> stringValues = new HashMap<String, String>();
    Map<String, Instant> instantValues = new HashMap<String, Instant>();
    Map<String, JsonObject> jsonObjectValues = new HashMap<String, JsonObject>();
    Map<String, JsonArray> jsonArrayValues = new HashMap<String, JsonArray>();
    Map<String, TestDataObject> dataObjectValues = new HashMap<String, TestDataObject>();
    Map<String, TestEnum> enumValues = new HashMap<String, TestEnum>();
    Map<String, TestGenEnum> genEnumValues = new HashMap<String, TestGenEnum>();

    private static <T> JsonObject toObject(Map<String, T> map) {
        return DataObjectWithMaps.toObject(map, o -> o);
    }

    private static <T> JsonObject toObject(Map<String, T> map, Function<T, Object> converter) {
        JsonObject object = new JsonObject();
        map.forEach((key, value) -> object.getMap().put(key, converter.apply(value)));
        return object;
    }

    private static <T> Map<String, T> fromObject(JsonObject obj, String name) {
        return DataObjectWithMaps.fromObject(obj, name, o -> o);
    }

    private static <T> Map<String, T> fromObject(JsonObject obj, String name, Function<Object, T> converter) {
        JsonObject array = obj.getJsonObject(name);
        if (array != null) {
            return array.stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> converter.apply(entry.getValue())));
        }
        return null;
    }

    public DataObjectWithMaps() {
    }

    public DataObjectWithMaps(DataObjectWithMaps that) {
        throw new UnsupportedOperationException("not used");
    }

    public DataObjectWithMaps(JsonObject json) {
        this.booleanValues = DataObjectWithMaps.fromObject(json, "booleanValues");
        this.shortValues = DataObjectWithMaps.fromObject(json, "shortValues", o -> Short.parseShort(o.toString()));
        this.integerValues = DataObjectWithMaps.fromObject(json, "integerValues");
        this.longValues = DataObjectWithMaps.fromObject(json, "longValues", o -> Long.parseLong(o.toString()));
        this.floatValues = DataObjectWithMaps.fromObject(json, "floatValues", o -> Float.valueOf(Float.parseFloat(o.toString())));
        this.doubleValues = DataObjectWithMaps.fromObject(json, "doubleValues");
        this.stringValues = DataObjectWithMaps.fromObject(json, "stringValues");
        this.instantValues = DataObjectWithMaps.fromObject(json, "instantValues", o -> Instant.parse(o.toString()));
        this.jsonObjectValues = DataObjectWithMaps.fromObject(json, "jsonObjectValues", o -> (JsonObject)o);
        this.jsonArrayValues = DataObjectWithMaps.fromObject(json, "jsonArrayValues", o -> (JsonArray)o);
        this.dataObjectValues = DataObjectWithMaps.fromObject(json, "dataObjectValues", o -> new TestDataObject((JsonObject)o));
        this.enumValues = DataObjectWithMaps.fromObject(json, "enumValues", o -> TestEnum.valueOf(o.toString()));
        this.genEnumValues = DataObjectWithMaps.fromObject(json, "genEnumValues", o -> TestGenEnum.valueOf(o.toString()));
    }

    public DataObjectWithMaps setShortValues(Map<String, Short> shortValues) {
        this.shortValues = shortValues;
        return this;
    }

    public DataObjectWithMaps setIntegerValues(Map<String, Integer> integerValues) {
        this.integerValues = integerValues;
        return this;
    }

    public DataObjectWithMaps setLongValues(Map<String, Long> longValues) {
        this.longValues = longValues;
        return this;
    }

    public DataObjectWithMaps setFloatValues(Map<String, Float> floatValues) {
        this.floatValues = floatValues;
        return this;
    }

    public DataObjectWithMaps setDoubleValues(Map<String, Double> doubleValues) {
        this.doubleValues = doubleValues;
        return this;
    }

    public DataObjectWithMaps setBooleanValues(Map<String, Boolean> booleanValues) {
        this.booleanValues = booleanValues;
        return this;
    }

    public DataObjectWithMaps setStringValues(Map<String, String> stringValue) {
        this.stringValues = stringValue;
        return this;
    }

    public DataObjectWithMaps setInstantValues(Map<String, Instant> instantValues) {
        this.instantValues = instantValues;
        return this;
    }

    public DataObjectWithMaps setEnumValues(Map<String, TestEnum> enumValues) {
        this.enumValues = enumValues;
        return this;
    }

    public DataObjectWithMaps setGenEnumValues(Map<String, TestGenEnum> genEnumValues) {
        this.genEnumValues = genEnumValues;
        return this;
    }

    public DataObjectWithMaps setDataObjectValues(Map<String, TestDataObject> dataObjectValues) {
        this.dataObjectValues = dataObjectValues;
        return this;
    }

    public DataObjectWithMaps setJsonObjectValues(Map<String, JsonObject> jsonObjectValues) {
        this.jsonObjectValues = jsonObjectValues;
        return this;
    }

    public DataObjectWithMaps setJsonArrayValues(Map<String, JsonArray> jsonArrayValues) {
        this.jsonArrayValues = jsonArrayValues;
        return this;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        if (this.booleanValues != null) {
            json.put("booleanValues", DataObjectWithMaps.toObject(this.booleanValues));
        }
        if (this.shortValues != null) {
            json.put("shortValues", DataObjectWithMaps.toObject(this.shortValues));
        }
        if (this.integerValues != null) {
            json.put("integerValues", DataObjectWithMaps.toObject(this.integerValues));
        }
        if (this.longValues != null) {
            json.put("longValues", DataObjectWithMaps.toObject(this.longValues));
        }
        if (this.floatValues != null) {
            json.put("floatValues", DataObjectWithMaps.toObject(this.floatValues));
        }
        if (this.doubleValues != null) {
            json.put("doubleValues", DataObjectWithMaps.toObject(this.doubleValues));
        }
        if (this.stringValues != null) {
            json.put("stringValues", DataObjectWithMaps.toObject(this.stringValues));
        }
        if (this.instantValues != null) {
            json.put("instantValues", DataObjectWithMaps.toObject(this.instantValues, Instant::toString));
        }
        if (this.jsonObjectValues != null) {
            json.put("jsonObjectValues", DataObjectWithMaps.toObject(this.jsonObjectValues));
        }
        if (this.jsonArrayValues != null) {
            json.put("jsonArrayValues", DataObjectWithMaps.toObject(this.jsonArrayValues));
        }
        if (this.dataObjectValues != null) {
            json.put("dataObjectValues", DataObjectWithMaps.toObject(this.dataObjectValues, TestDataObject::toJson));
        }
        if (this.enumValues != null) {
            json.put("enumValues", DataObjectWithMaps.toObject(this.enumValues));
        }
        if (this.genEnumValues != null) {
            json.put("genEnumValues", DataObjectWithMaps.toObject(this.genEnumValues));
        }
        return json;
    }
}

