/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen.testmodel;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import java.util.Objects;

@DataObject
public class TestDataObject {
    private String foo;
    private int bar;
    private double wibble;

    public TestDataObject() {
    }

    public TestDataObject(TestDataObject other) {
        this.foo = other.foo;
        this.bar = other.bar;
        this.wibble = other.wibble;
    }

    public TestDataObject(JsonObject json) {
        this.foo = json.getString("foo", null);
        this.bar = json.getInteger("bar", Integer.valueOf(0));
        this.wibble = json.getDouble("wibble", Double.valueOf(0.0));
    }

    public String getFoo() {
        return this.foo;
    }

    public TestDataObject setFoo(String foo) {
        this.foo = foo;
        return this;
    }

    public int getBar() {
        return this.bar;
    }

    public TestDataObject setBar(int bar) {
        this.bar = bar;
        return this;
    }

    public double getWibble() {
        return this.wibble;
    }

    public TestDataObject setWibble(double wibble) {
        this.wibble = wibble;
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TestDataObject) {
            TestDataObject that = (TestDataObject)obj;
            return Objects.equals(this.foo, that.foo) && this.bar == that.bar && this.wibble == that.wibble;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getFoo(), this.getBar(), this.getWibble());
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.put("foo", this.foo);
        json.put("bar", Integer.valueOf(this.bar));
        json.put("wibble", Double.valueOf(this.wibble));
        return json;
    }
}

