/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.groovy;

import io.vertx.core.AsyncResult;
import java.util.function.Function;
import org.junit.Assert;

public class AsyncResultChecker {
    int count = 0;

    void assertResult(Object expected, Object result) {
        Assert.assertEquals((Object)expected, (Object)result);
        ++this.count;
    }

    void assertAsyncResult(Object expected, AsyncResult<?> result) {
        this.assertAsyncResult(expected, result, e -> e);
    }

    <R, E> void assertAsyncResult(E expected, AsyncResult<R> result, Function<R, E> unwrapper) {
        Assert.assertTrue((boolean)result.succeeded());
        Assert.assertFalse((boolean)result.failed());
        Object r = result.result();
        E unwrapped = unwrapper.apply(r);
        Assert.assertEquals(expected, unwrapped);
        Assert.assertNull((Object)result.cause());
        ++this.count;
    }

    void assertAsyncFailure(String expectedMsg, AsyncResult<?> result) {
        Assert.assertNull((Object)result.result());
        Assert.assertFalse((boolean)result.succeeded());
        Assert.assertTrue((boolean)result.failed());
        Assert.assertEquals((Object)expectedMsg, (Object)result.cause().getMessage());
        ++this.count;
    }
}

