/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.groovy;

import io.vertx.core.Vertx;
import io.vertx.lang.groovy.basescripts.FooScript;
import java.net.URL;
import java.util.AbstractMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.junit.Assert;
import org.junit.Test;

public class CompilerConfigurationTest {
    public static CompilerConfiguration config;

    @Test
    public void testDefaultPropertiesGroovy() throws Exception {
        this.deployVerticle("groovy:io/vertx/lang/groovy/CompilerConfigVerticleScript.groovy", new AbstractMap.SimpleEntry<String, String>("compilerConfiguration.groovy", "configs/compilerConfiguration.groovy"));
        Assert.assertEquals((Object)"groovy.lang.Script", (Object)config.getScriptBaseClass());
        Assert.assertEquals((Object)"UTF-8", (Object)config.getSourceEncoding());
        Assert.assertEquals((long)1L, (long)config.getCompilationCustomizers().size());
        Assert.assertTrue((boolean)(config.getCompilationCustomizers().get(0) instanceof ImportCustomizer));
    }

    @Test
    public void testDefaultPropertiesFile() throws Exception {
        this.deployVerticle("groovy:io/vertx/lang/groovy/CompilerConfigVerticleScript.groovy", new AbstractMap.SimpleEntry<String, String>("compilerConfiguration.properties", "configs/compilerConfiguration.properties"));
        Assert.assertEquals((Object)FooScript.class.getName(), (Object)config.getScriptBaseClass());
    }

    @Test
    public void tesSystemPropertytMissingConfiguration() throws Exception {
        System.setProperty("vertx.groovy.compilerConfiguration", "no.properties");
        try {
            this.deployVerticle("groovy:io/vertx/lang/groovy/CompilerConfigVerticleScript.groovy", new Map.Entry[0]);
            Assert.assertEquals(null, (Object)config.getScriptBaseClass());
        }
        finally {
            System.clearProperty("vertx.groovy.compilerConfiguration");
        }
    }

    @Test
    public void testSystemPropertyFile() throws Exception {
        System.setProperty("vertx.groovy.compilerConfiguration", "configs/compilerConfiguration.properties");
        try {
            this.deployVerticle("groovy:io/vertx/lang/groovy/CompilerConfigVerticleScript.groovy", new Map.Entry[0]);
            Assert.assertEquals((Object)FooScript.class.getName(), (Object)config.getScriptBaseClass());
        }
        finally {
            System.clearProperty("vertx.groovy.compilerConfiguration");
        }
    }

    @Test
    public void testSystemPropertyGroovy() throws Exception {
        System.setProperty("vertx.groovy.compilerConfiguration", "configs/compilerConfiguration.groovy");
        try {
            this.deployVerticle("groovy:io/vertx/lang/groovy/CompilerConfigVerticleScript.groovy", new Map.Entry[0]);
            Assert.assertEquals((Object)"groovy.lang.Script", (Object)config.getScriptBaseClass());
            Assert.assertEquals((Object)"UTF-8", (Object)config.getSourceEncoding());
            Assert.assertEquals((long)1L, (long)config.getCompilationCustomizers().size());
            Assert.assertTrue((boolean)(config.getCompilationCustomizers().get(0) instanceof ImportCustomizer));
        }
        finally {
            System.clearProperty("vertx.groovy.compilerConfiguration");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deployVerticle(String verticleName, final Map.Entry<String, String> ... aliases) throws Exception {
        Vertx vertx = Vertx.vertx();
        ClassLoader prevLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader nextLoader = new ClassLoader(prevLoader){

            @Override
            public URL getResource(String name) {
                for (Map.Entry alias : aliases) {
                    if (!((String)alias.getKey()).equals(name)) continue;
                    name = (String)alias.getValue();
                    break;
                }
                return super.getResource(name);
            }
        };
        Thread.currentThread().setContextClassLoader(nextLoader);
        try {
            CountDownLatch latch = new CountDownLatch(1);
            vertx.deployVerticle(verticleName, ar -> latch.countDown());
            latch.await(10L, TimeUnit.SECONDS);
        }
        finally {
            Thread.currentThread().setContextClassLoader(prevLoader);
        }
    }
}

