/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.groovy;

import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.Script;
import io.vertx.core.AsyncResult;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Handler;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.lang.groovy.GroovyVerticle;
import io.vertx.lang.groovy.ScriptVerticle;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import junit.framework.AssertionFailedError;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class DeploymentTest {
    boolean isStarted() {
        return System.getProperty("started").equals("true");
    }

    boolean isStopped() {
        return System.getProperty("stopped").equals("true");
    }

    private static <T> T assertResult(AsyncResult<T> asyncResult) {
        if (asyncResult.succeeded()) {
            return (T)asyncResult.result();
        }
        AssertionFailedError afe = new AssertionFailedError();
        afe.initCause(asyncResult.cause());
        throw afe;
    }

    private Class assertScript(String script) {
        GroovyClassLoader loader = new GroovyClassLoader(this.getClass().getClassLoader());
        try {
            return loader.loadClass(this.getClass().getPackage().getName() + "." + script);
        }
        catch (ClassNotFoundException e) {
            AssertionFailedError afe = new AssertionFailedError();
            afe.initCause((Throwable)e);
            throw afe;
        }
    }

    private String getRelativePath(String classpathResource) throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource(classpathResource);
        Assert.assertNotNull((Object)url);
        URI verticleURI = url.toURI();
        URI userDir = new File(System.getProperty("user.dir")).toURI();
        URI relativeURI = userDir.relativize(verticleURI);
        Assert.assertTrue((!relativeURI.isAbsolute() ? 1 : 0) != 0);
        return relativeURI.toString();
    }

    private String getAbsolutePath(String classpathResource) throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("io/vertx/lang/groovy/LifeCycleVerticleClass.groovy");
        Assert.assertNotNull((Object)url);
        return new File(url.toURI()).getAbsolutePath();
    }

    @After
    public void after() {
        System.clearProperty("started");
        System.clearProperty("stopped");
    }

    @Test
    public void testDeployVerticleClass() throws Exception {
        this.assertDeploy((vertx, onDeploy) -> vertx.deployVerticle("io/vertx/lang/groovy/LifeCycleVerticleClass.groovy", onDeploy));
        Assert.assertTrue((boolean)this.isStarted());
        Assert.assertTrue((boolean)this.isStopped());
    }

    @Test
    public void testAsyncDeployVerticleClass() throws Exception {
        this.assertDeploy((vertx, onDeploy) -> vertx.deployVerticle("io/vertx/lang/groovy/LifeCycleAsyncVerticleClass.groovy", onDeploy));
        Assert.assertTrue((boolean)this.isStarted());
        Assert.assertTrue((boolean)this.isStopped());
    }

    @Test
    public void testDeployVerticleClassInstance() throws Exception {
        Class clazz = this.assertScript("LifeCycleVerticleClass");
        GroovyVerticle verticle = (GroovyVerticle)clazz.newInstance();
        this.assertDeploy((vertx, onDeploy) -> vertx.deployVerticle(verticle.asJavaVerticle(), onDeploy));
        Assert.assertTrue((boolean)this.isStarted());
        Assert.assertTrue((boolean)this.isStopped());
    }

    @Test
    public void testDeployVerticleScript() throws Exception {
        this.assertDeploy((vertx, onDeploy) -> vertx.deployVerticle("io/vertx/lang/groovy/LifeCycleVerticleScript.groovy", onDeploy));
        Assert.assertTrue((boolean)this.isStarted());
        Assert.assertTrue((boolean)this.isStopped());
    }

    @Test
    public void testDeployVerticleScriptInstance() throws Exception {
        Class clazz = this.assertScript("LifeCycleVerticleScript");
        Script script = (Script)clazz.newInstance();
        ScriptVerticle verticle = new ScriptVerticle(script);
        this.assertDeploy((vertx, onDeploy) -> vertx.deployVerticle((Verticle)verticle, onDeploy));
        Assert.assertTrue((boolean)this.isStarted());
        Assert.assertTrue((boolean)this.isStopped());
    }

    @Test
    public void testAsyncDeployVerticleScript() throws Exception {
        this.assertDeploy((vertx, onDeploy) -> vertx.deployVerticle("io/vertx/lang/groovy/LifeCycleAsyncVerticleScript.groovy", onDeploy));
        Assert.assertTrue((boolean)this.isStarted());
        Assert.assertTrue((boolean)this.isStopped());
    }

    @Test
    public void testDeployVerticleClassFromRelativeFile() throws Exception {
        String relativePath = this.getRelativePath("io/vertx/lang/groovy/LifeCycleVerticleClass.groovy");
        this.assertDeploy((vertx, onDeploy) -> vertx.deployVerticle(relativePath, onDeploy));
        Assert.assertTrue((boolean)this.isStarted());
        Assert.assertTrue((boolean)this.isStopped());
    }

    @Test
    public void testDeployVerticleClassFromAbsoluteFile() throws Exception {
        String verticlePath = this.getAbsolutePath("io/vertx/lang/groovy/LifeCycleVerticleClass.groovy");
        this.assertDeploy((vertx, onDeploy) -> vertx.deployVerticle(verticlePath, onDeploy));
        Assert.assertTrue((boolean)this.isStarted());
        Assert.assertTrue((boolean)this.isStopped());
    }

    @Test
    public void testResolveSamePackageFromClassPath() throws Exception {
        this.assertDeploy((vertx, onDeploy) -> vertx.deployVerticle("io/vertx/lang/groovy/ResolveSamePackageVerticleClass.groovy", new DeploymentOptions().setConfig(new JsonObject()), onDeploy));
        Assert.assertTrue((boolean)this.isStarted());
    }

    @Test
    public void testResolveSamePackageFromRelativeFile() throws Exception {
        String relativePath = this.getRelativePath("io/vertx/lang/groovy/ResolveSamePackageVerticleClass.groovy");
        this.assertDeploy((vertx, onDeploy) -> vertx.deployVerticle(relativePath, new DeploymentOptions().setConfig(new JsonObject()), onDeploy));
        Assert.assertTrue((boolean)this.isStarted());
    }

    @Test
    public void testResolveSamePackageFromAbsoluteFile() throws Exception {
        String relativePath = this.getAbsolutePath("io/vertx/lang/groovy/ResolveSamePackageVerticleClass.groovy");
        this.assertDeploy((vertx, onDeploy) -> vertx.deployVerticle(relativePath, new DeploymentOptions().setConfig(new JsonObject()), onDeploy));
        Assert.assertTrue((boolean)this.isStarted());
    }

    @Test
    public void testResolveChildPackageFromClassPath() throws Exception {
        this.assertDeploy((vertx, onDeploy) -> vertx.deployVerticle("io/vertx/lang/groovy/ResolveChildPackageVerticleClass.groovy", new DeploymentOptions().setConfig(new JsonObject()), onDeploy));
        Assert.assertTrue((boolean)this.isStarted());
    }

    @Test
    public void testResolveChildPackageFromRelativeFile() throws Exception {
        String relativePath = this.getRelativePath("io/vertx/lang/groovy/ResolveChildPackageVerticleClass.groovy");
        this.assertDeploy((vertx, onDeploy) -> vertx.deployVerticle(relativePath, new DeploymentOptions().setConfig(new JsonObject()), onDeploy));
        Assert.assertTrue((boolean)this.isStarted());
    }

    @Test
    public void testResolveChildPackageFromAbsoluteFile() throws Exception {
        String relativePath = this.getAbsolutePath("io/vertx/lang/groovy/ResolveChildPackageVerticleClass.groovy");
        this.assertDeploy((vertx, onDeploy) -> vertx.deployVerticle(relativePath, new DeploymentOptions().setConfig(new JsonObject()), onDeploy));
        Assert.assertTrue((boolean)this.isStarted());
    }

    @Test
    public void testResolveVertxInJavaVerticleClass() throws Exception {
        this.assertDeploy((vertx, onDeploy) -> vertx.deployVerticle("io/vertx/lang/groovy/ResolveVertxJavaVerticleClass.groovy", new DeploymentOptions().setConfig(new JsonObject()), onDeploy));
        Assert.assertTrue((boolean)this.isStarted());
    }

    @Test
    public void testResolveVertxInGroovyVerticleClass() throws Exception {
        this.assertDeploy((vertx, onDeploy) -> vertx.deployVerticle("io/vertx/lang/groovy/ResolveVertxGroovyVerticleClass.groovy", new DeploymentOptions().setConfig(new JsonObject()), onDeploy));
        Assert.assertTrue((boolean)this.isStarted());
    }

    @Test
    public void testResolveVertxInVerticleScript() throws Exception {
        this.assertDeploy((vertx, onDeploy) -> vertx.deployVerticle("io/vertx/lang/groovy/ResolveVertxVerticleScript.groovy", new DeploymentOptions().setConfig(new JsonObject()), onDeploy));
        Assert.assertTrue((boolean)this.isStarted());
    }

    @Test
    public void testReuseBindingInScript() throws Exception {
        Class clazz = this.assertScript("ReuseBindingVerticleScript");
        Script script = (Script)clazz.newInstance();
        Binding binding = new Binding();
        binding.setVariable("myobject", new Object());
        script.setBinding(binding);
        ScriptVerticle verticle = new ScriptVerticle(script);
        this.assertDeploy((vertx, onDeploy) -> vertx.deployVerticle((Verticle)verticle, onDeploy));
        Assert.assertTrue((boolean)this.isStarted());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeployVerticleGroovyScriptNoStop() throws Exception {
        try (Vertx vertx = Vertx.vertx();){
            ArrayBlockingQueue deployed = new ArrayBlockingQueue(1);
            vertx.deployVerticle("io/vertx/lang/groovy//NoStopVerticleScript.groovy", deployed::add);
            AsyncResult deployment = (AsyncResult)deployed.poll(10L, TimeUnit.SECONDS);
            String deploymentId = (String)DeploymentTest.assertResult(deployment);
            ArrayBlockingQueue undeployed = new ArrayBlockingQueue(1);
            vertx.undeploy(deploymentId, undeployed::add);
            AsyncResult undeployment = (AsyncResult)undeployed.poll(10L, TimeUnit.SECONDS);
            DeploymentTest.assertResult(undeployment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertDeploy(BiConsumer<Vertx, Handler<AsyncResult<String>>> deployer) throws Exception {
        try (Vertx vertx = Vertx.vertx();){
            ArrayBlockingQueue deployed = new ArrayBlockingQueue(1);
            deployer.accept(vertx, (Handler<AsyncResult<String>>)((Handler)deployed::add));
            AsyncResult deployment = (AsyncResult)deployed.poll(10L, TimeUnit.SECONDS);
            String deploymentId = (String)DeploymentTest.assertResult(deployment);
            ArrayBlockingQueue undeployed = new ArrayBlockingQueue(1);
            vertx.undeploy(deploymentId, undeployed::add);
            AsyncResult undeployment = (AsyncResult)undeployed.poll(10L, TimeUnit.SECONDS);
            DeploymentTest.assertResult(undeployment);
        }
    }
}

