/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.groovy;

import io.vertx.core.Vertx;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class TransformTest {
    @Rule
    public final TestName name = new TestName();

    @Test
    public void testScriptWithClassLiteral() throws Exception {
        this.runTest();
    }

    @Test
    public void testClassField() throws Exception {
        this.runTest();
    }

    @Test
    public void testClassQualifiedField() throws Exception {
        this.runTest();
    }

    @Test
    public void testClassQualifiedStaticClassLiteral() throws Exception {
        this.runTest();
    }

    @Test
    public void testClassQualifiedStaticMethodCall() throws Exception {
        this.runTest();
    }

    @Test
    public void testClassQualifiedTypeArgField() throws Exception {
        this.runTest();
    }

    @Test
    public void testClassInnerClass() throws Exception {
        this.runTest();
    }

    @Test
    public void testClassInnerClassQualified() throws Exception {
        this.runTest();
    }

    @Test
    public void testClassInnerClassQualifiedTypeArg() throws Exception {
        this.runTest();
    }

    @Test
    public void testClassMethodParam() throws Exception {
        this.runTest();
    }

    @Test
    public void testClassMethodQualifiedParam() throws Exception {
        this.runTest();
    }

    @Test
    public void testClassMethodQualifiedTypeArgParam() throws Exception {
        this.runTest();
    }

    @Test
    public void testClassMethodGenericParam() throws Exception {
        this.runTest();
    }

    @Test
    public void testScriptWithCast() throws Exception {
        this.runTest();
    }

    @Test
    public void testScriptWithCastQualified() throws Exception {
        this.runTest();
    }

    @Test
    public void testScriptWithCastQualifiedTypeArg() throws Exception {
        this.runTest();
    }

    @Test
    public void testScriptWithQualifiedParameterizedDecl() throws Exception {
        this.runTest();
    }

    @Test
    public void testScriptWithMethodParam() throws Exception {
        this.runTest();
    }

    @Test
    public void testScriptWithMethodQualifiedParam() throws Exception {
        this.runTest();
    }

    @Test
    public void testScriptWithMethodQualifiedTypeArgParam() throws Exception {
        this.runTest();
    }

    @Test
    public void testScriptWithDecl() throws Exception {
        this.runTest();
    }

    @Test
    public void testScriptWithQualifiedDecl() throws Exception {
        this.runTest();
    }

    @Test
    public void testScriptWithQualifiedTypeArgDecl() throws Exception {
        this.runTest();
    }

    @Test
    public void testScriptWithMethodReturn() throws Exception {
        this.runTest();
    }

    @Test
    public void testScriptWithMethodQualifiedReturn() throws Exception {
        this.runTest();
    }

    @Test
    public void testScriptWithMethodQualifiedTypeArgReturn() throws Exception {
        this.runTest();
    }

    @Test
    public void testScriptWithClosureAccessingField() throws Exception {
        this.runTest();
    }

    @Test
    public void testScriptWithClosureParamDecl() throws Exception {
        this.runTest();
    }

    @Test
    public void testScriptWithClosureQualifiedParamDecl() throws Exception {
        this.runTest();
    }

    @Test
    public void testScriptWithClosureQualifiedTypeArgParamDecl() throws Exception {
        this.runTest();
    }

    @Test
    public void testScriptWithClosureWithNoParameters() throws Exception {
        this.runTest();
    }

    @Test
    public void testScriptWithForLoopQualifiedDecl() throws Exception {
        this.runTest();
    }

    @Test
    public void testScriptWithForLoopBlock() throws Exception {
        this.runTest();
    }

    @Test
    public void testScriptWithWhileBlock() throws Exception {
        this.runTest();
    }

    @Test
    public void testAbstractMethod() throws Exception {
        this.runTest();
    }

    private void runTest() throws Exception {
        Vertx vertx = Vertx.vertx();
        CompletableFuture fut = new CompletableFuture();
        vertx.eventBus().localConsumer("the-address", msg -> fut.complete(null));
        vertx.deployVerticle("transform/" + this.name.getMethodName() + ".groovy", ar -> {
            if (ar.failed()) {
                fut.completeExceptionally(ar.cause());
            }
        });
        fut.get(20L, TimeUnit.SECONDS);
    }
}

