/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */
package io.vertx.codegen.extra;

import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;

/**
 * @author <a href="mailto:julien@julienviet.com">Julien Viet</a>
 */
@VertxGen
public interface Converter {

  static boolean acceptNullJsonObjectValue(JsonObject json) {
    return json.size() == 1 && json.containsKey("nullkey") && json.getValue("nullkey") == null;
  }

  static boolean acceptNullJsonArrayValue(JsonArray json) {
    return json.size() == 1 && json.getValue(0) == null;
  }

  static JsonObject returnJsonObjectWithNullValue() {
    return new JsonObject().put("nullKey", (Object) null);
  }

  static JsonArray returnJsonArrayWithNullValue() {
    return new JsonArray().addNull();
  }
}
