/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mqtt.impl;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.mqtt.MqttFixedHeader;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageFactory;
import io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.CloseFuture;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.impl.NetSocketInternal;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.mqtt.MqttClientOptions;
import io.vertx.mqtt.impl.MqttClientImpl;
import io.vertx.mqtt.messages.MqttConnAckMessage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=VertxUnitRunner.class)
public class MqttClientImplTest {
    private VertxInternal vertx;
    private ContextInternal context;
    private NetClient netClient;
    private NetSocketInternal netSocket;

    @Before
    public void setUp() {
        this.netClient = (NetClient)Mockito.mock(NetClient.class);
        this.vertx = (VertxInternal)Mockito.mock(VertxInternal.class);
        this.context = (ContextInternal)Mockito.mock(ContextInternal.class);
        Mockito.when((Object)this.context.owner()).thenReturn((Object)this.vertx);
        Mockito.when((Object)this.context.failedFuture((Throwable)ArgumentMatchers.any(Throwable.class))).thenAnswer(invocation -> Future.failedFuture((Throwable)((Throwable)invocation.getArgument(0, Throwable.class))));
        ((ContextInternal)Mockito.doAnswer(invocation -> {
            Handler handler = (Handler)invocation.getArgument(0);
            handler.handle(null);
            return null;
        }).when((Object)this.context)).runOnContext((Handler)ArgumentMatchers.any(Handler.class));
        Mockito.when((Object)this.vertx.getOrCreateContext()).thenReturn((Object)this.context);
        Mockito.when((Object)this.vertx.createNetClient((NetClientOptions)ArgumentMatchers.any(NetClientOptions.class), (CloseFuture)ArgumentMatchers.any(CloseFuture.class))).thenReturn((Object)this.netClient);
    }

    @Test
    public void testPublishQos1DoesNotTimeOutByDefault() {
        Handler expirationHandler = (Handler)Mockito.mock(Handler.class);
        Handler unknownPacketIdHandler = (Handler)Mockito.mock(Handler.class);
        MqttClientImpl client = this.givenAConnectedClient(-1);
        client.publishCompletionExpirationHandler(expirationHandler);
        client.publishCompletionUnknownPacketIdHandler(unknownPacketIdHandler);
        ArgumentCaptor messageHandler = ArgumentCaptor.forClass(Handler.class);
        ((NetSocketInternal)Mockito.verify((Object)this.netSocket)).messageHandler((Handler)messageHandler.capture());
        Promise sendHandler = Promise.promise();
        client.publish("topic", Buffer.buffer((String)"Hello"), MqttQoS.AT_LEAST_ONCE, false, false, (Handler)sendHandler);
        Assert.assertTrue((boolean)sendHandler.future().succeeded());
        ((VertxInternal)Mockito.verify((Object)this.vertx, (VerificationMode)Mockito.never())).setTimer(ArgumentMatchers.anyLong(), (Handler)ArgumentMatchers.any(Handler.class));
        ((Handler)Mockito.verify((Object)expirationHandler, (VerificationMode)Mockito.never())).handle((Object)ArgumentMatchers.anyInt());
        ((Handler)Mockito.verify((Object)unknownPacketIdHandler, (VerificationMode)Mockito.never())).handle((Object)ArgumentMatchers.anyInt());
        Assert.assertEquals((long)1L, (long)client.getInFlightMessagesCount());
    }

    @Test
    public void testPublishQos1InvokesHandlerOnPubackTimeout() {
        Handler expirationHandler = (Handler)Mockito.mock(Handler.class);
        Handler unknownPacketIdHandler = (Handler)Mockito.mock(Handler.class);
        MqttClientImpl client = this.givenAConnectedClient(5);
        client.publishCompletionExpirationHandler(expirationHandler);
        client.publishCompletionUnknownPacketIdHandler(unknownPacketIdHandler);
        ArgumentCaptor messageHandler = ArgumentCaptor.forClass(Handler.class);
        ((NetSocketInternal)Mockito.verify((Object)this.netSocket)).messageHandler((Handler)messageHandler.capture());
        Promise sendHandler = Promise.promise();
        client.publish("topic", Buffer.buffer((String)"Hello"), MqttQoS.AT_LEAST_ONCE, false, false, (Handler)sendHandler);
        Assert.assertTrue((boolean)sendHandler.future().succeeded());
        ArgumentCaptor timerTask = ArgumentCaptor.forClass(Handler.class);
        ((VertxInternal)Mockito.verify((Object)this.vertx)).setTimer(ArgumentMatchers.anyLong(), (Handler)timerTask.capture());
        ((Handler)timerTask.getValue()).handle((Object)1L);
        ((Handler)Mockito.verify((Object)expirationHandler)).handle(ArgumentMatchers.eq((Object)sendHandler.future().result()));
        Assert.assertEquals((long)0L, (long)client.getInFlightMessagesCount());
        ((Handler)messageHandler.getValue()).handle((Object)MqttClientImplTest.createAckMessage(MqttMessageType.PUBACK, (Integer)sendHandler.future().result()));
        ((Handler)Mockito.verify((Object)unknownPacketIdHandler)).handle(ArgumentMatchers.eq((Object)sendHandler.future().result()));
    }

    @Test
    public void testPublishQos2InvokesHandlerOnPubrecTimeout() {
        Handler expirationHandler = (Handler)Mockito.mock(Handler.class);
        Handler unknownPacketIdHandler = (Handler)Mockito.mock(Handler.class);
        MqttClientImpl client = this.givenAConnectedClient(5);
        client.publishCompletionExpirationHandler(expirationHandler);
        client.publishCompletionUnknownPacketIdHandler(unknownPacketIdHandler);
        ArgumentCaptor messageHandler = ArgumentCaptor.forClass(Handler.class);
        ((NetSocketInternal)Mockito.verify((Object)this.netSocket)).messageHandler((Handler)messageHandler.capture());
        Promise sendHandler = Promise.promise();
        client.publish("topic", Buffer.buffer((String)"Hello"), MqttQoS.EXACTLY_ONCE, false, false, (Handler)sendHandler);
        Assert.assertTrue((boolean)sendHandler.future().succeeded());
        ArgumentCaptor timerTask = ArgumentCaptor.forClass(Handler.class);
        ((VertxInternal)Mockito.verify((Object)this.vertx)).setTimer(ArgumentMatchers.anyLong(), (Handler)timerTask.capture());
        ((Handler)timerTask.getValue()).handle((Object)1L);
        ((Handler)Mockito.verify((Object)expirationHandler)).handle(ArgumentMatchers.eq((Object)sendHandler.future().result()));
        Assert.assertEquals((long)0L, (long)client.getInFlightMessagesCount());
        ((Handler)messageHandler.getValue()).handle((Object)MqttClientImplTest.createAckMessage(MqttMessageType.PUBREC, (Integer)sendHandler.future().result()));
        ((Handler)Mockito.verify((Object)unknownPacketIdHandler)).handle(ArgumentMatchers.eq((Object)sendHandler.future().result()));
    }

    @Test
    public void testPublishQos2InvokesHandlerOnPubcompTimeout() {
        Handler expirationHandler = (Handler)Mockito.mock(Handler.class);
        Handler unknownPacketIdHandler = (Handler)Mockito.mock(Handler.class);
        MqttClientImpl client = this.givenAConnectedClient(5);
        client.publishCompletionExpirationHandler(expirationHandler);
        client.publishCompletionUnknownPacketIdHandler(unknownPacketIdHandler);
        ArgumentCaptor messageHandler = ArgumentCaptor.forClass(Handler.class);
        ((NetSocketInternal)Mockito.verify((Object)this.netSocket)).messageHandler((Handler)messageHandler.capture());
        Promise sendHandler = Promise.promise();
        client.publish("topic", Buffer.buffer((String)"Hello"), MqttQoS.EXACTLY_ONCE, false, false, (Handler)sendHandler);
        Assert.assertTrue((boolean)sendHandler.future().succeeded());
        ((Handler)messageHandler.getValue()).handle((Object)MqttClientImplTest.createAckMessage(MqttMessageType.PUBREC, (Integer)sendHandler.future().result()));
        Assert.assertEquals((long)1L, (long)client.getInFlightMessagesCount());
        ArgumentCaptor timerTask = ArgumentCaptor.forClass(Handler.class);
        ((VertxInternal)Mockito.verify((Object)this.vertx, (VerificationMode)Mockito.times((int)2))).setTimer(ArgumentMatchers.anyLong(), (Handler)timerTask.capture());
        ((Handler)timerTask.getValue()).handle((Object)1L);
        ((Handler)Mockito.verify((Object)expirationHandler)).handle(ArgumentMatchers.eq((Object)sendHandler.future().result()));
        Assert.assertEquals((long)0L, (long)client.getInFlightMessagesCount());
        ((Handler)messageHandler.getValue()).handle((Object)MqttClientImplTest.createAckMessage(MqttMessageType.PUBCOMP, (Integer)sendHandler.future().result()));
        ((Handler)Mockito.verify((Object)unknownPacketIdHandler)).handle(ArgumentMatchers.eq((Object)sendHandler.future().result()));
    }

    private MqttClientImpl givenAConnectedClient(int timeout) {
        MqttClientOptions options = new MqttClientOptions();
        options.setAckTimeout(timeout);
        MqttClientImpl client = new MqttClientImpl((Vertx)this.vertx, options);
        PromiseInternal promise = (PromiseInternal)Mockito.mock(PromiseInternal.class);
        Mockito.when((Object)promise.future()).thenReturn((Object)Future.succeededFuture((Object)Mockito.mock(MqttConnAckMessage.class)));
        Mockito.when((Object)this.context.promise()).thenReturn((Object)promise);
        ChannelPipeline channelPipeline = (ChannelPipeline)Mockito.mock(ChannelPipeline.class);
        ChannelHandlerContext channelHandlerContext = (ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class);
        Mockito.when((Object)channelHandlerContext.pipeline()).thenReturn((Object)channelPipeline);
        this.netSocket = (NetSocketInternal)Mockito.mock(NetSocketInternal.class);
        Mockito.when((Object)this.netSocket.channelHandlerContext()).thenReturn((Object)channelHandlerContext);
        Mockito.when((Object)this.netSocket.writeMessage(ArgumentMatchers.any())).thenReturn((Object)Future.succeededFuture());
        Mockito.when((Object)this.netClient.connect(ArgumentMatchers.anyInt(), ArgumentMatchers.anyString(), (String)ArgumentMatchers.any(), (Handler)ArgumentMatchers.any(Handler.class))).thenAnswer(invocation -> {
            Handler done = (Handler)invocation.getArgument(3);
            done.handle((Object)Future.succeededFuture((Object)this.netSocket));
            return this.netClient;
        });
        client.connect(1883, "localhost", conAttempt -> {});
        return client;
    }

    private static MqttMessage createAckMessage(MqttMessageType type, int packetId) {
        MqttFixedHeader fixedHeader = new MqttFixedHeader(type, false, MqttQoS.AT_MOST_ONCE, false, 0);
        MqttMessageIdVariableHeader variableHeader = MqttMessageIdVariableHeader.from((int)packetId);
        return MqttMessageFactory.newMessage((MqttFixedHeader)fixedHeader, (Object)variableHeader, null);
    }
}

