/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mqtt.it;

import io.netty.handler.codec.mqtt.MqttConnectReturnCode;
import io.vertx.core.Vertx;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.mqtt.MqttClient;
import io.vertx.mqtt.MqttClientOptions;
import io.vertx.mqtt.MqttConnectionException;
import io.vertx.mqtt.MqttServer;
import io.vertx.mqtt.it.MqttClientBaseIT;
import org.junit.Assert;
import org.junit.Test;

public class MqttClientConnectIT
extends MqttClientBaseIT {
    @Test
    public void connectDisconnect(TestContext context) throws InterruptedException {
        Async async = context.async();
        MqttClient client = MqttClient.create((Vertx)Vertx.vertx());
        client.connect(this.port, this.host, c -> {
            Assert.assertTrue((boolean)c.succeeded());
            client.disconnect(ar -> {
                Assert.assertTrue((boolean)ar.succeeded());
                async.countDown();
            });
        });
        async.await();
    }

    @Test
    public void connectDisconnectWithIdleOption(TestContext context) {
        Async async = context.async();
        MqttClientOptions options = new MqttClientOptions();
        options.setKeepAliveInterval(100);
        MqttClient client = MqttClient.create((Vertx)Vertx.vertx(), (MqttClientOptions)options);
        client.connect(this.port, this.host, c -> {
            Assert.assertTrue((boolean)c.succeeded());
            client.disconnect(ar -> {
                Assert.assertTrue((boolean)ar.succeeded());
                async.countDown();
            });
        });
        async.await();
    }

    @Test
    public void closeHandler(TestContext context) throws InterruptedException {
        Async async = context.async();
        MqttClient client = MqttClient.create((Vertx)Vertx.vertx(), (MqttClientOptions)new MqttClientOptions().setKeepAliveInterval(5).setAutoKeepAlive(false));
        client.closeHandler(v -> async.countDown());
        client.connect(this.port, this.host, c -> Assert.assertTrue((boolean)c.succeeded()));
        async.await();
    }

    @Test
    public void tcpConnectionFails(TestContext context) {
        Async async = context.async();
        MqttClient client = MqttClient.create((Vertx)Vertx.vertx());
        client.closeHandler(v -> context.fail());
        client.connect(1883, "localhost", c -> {
            Assert.assertTrue((boolean)c.failed());
            Assert.assertFalse((boolean)client.isConnected());
            async.complete();
        });
        async.await();
    }

    @Test
    public void connackNotOk(TestContext context) {
        Async async = context.async();
        Async asyncServer = context.async();
        Vertx vertx = Vertx.vertx();
        MqttServer server = MqttServer.create((Vertx)vertx);
        server.endpointHandler(endpoint -> endpoint.reject(MqttConnectReturnCode.CONNECTION_REFUSED_SERVER_UNAVAILABLE));
        server.listen(1883, context.asyncAssertSuccess(v -> asyncServer.complete()));
        asyncServer.await();
        MqttClient client = MqttClient.create((Vertx)vertx);
        client.closeHandler(v -> context.fail());
        client.connect(1883, "localhost", c -> {
            Assert.assertTrue((boolean)c.failed());
            Assert.assertTrue((boolean)(c.cause() instanceof MqttConnectionException));
            MqttConnectionException connEx = (MqttConnectionException)c.cause();
            Assert.assertEquals((Object)connEx.code(), (Object)MqttConnectReturnCode.CONNECTION_REFUSED_SERVER_UNAVAILABLE);
            Assert.assertFalse((boolean)client.isConnected());
            async.complete();
        });
        async.await();
    }
}

