/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mqtt.it;

import io.vertx.core.Vertx;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.mqtt.MqttClient;
import io.vertx.mqtt.MqttClientOptions;
import io.vertx.mqtt.it.MqttClientBaseIT;
import junit.framework.TestCase;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Test;

public class MqttClientIdIT
extends MqttClientBaseIT {
    private static final Logger log = LoggerFactory.getLogger(MqttClientIdIT.class);

    @Test
    public void afterConnectClientIdGenerated(TestContext context) throws InterruptedException {
        Async async = context.async();
        MqttClientOptions options = new MqttClientOptions();
        MqttClient client = MqttClient.create((Vertx)Vertx.vertx(), (MqttClientOptions)options);
        Assert.assertThat((Object)options.getClientId(), (Matcher)IsNull.nullValue());
        client.connect(this.port, this.host, c -> {
            Assert.assertTrue((boolean)c.succeeded());
            Assert.assertTrue((client.clientId().length() == 36 ? 1 : 0) != 0);
            Assert.assertThat((Object)client.clientId(), (Matcher)IsNull.notNullValue());
            TestCase.assertFalse((boolean)client.clientId().isEmpty());
            log.info((Object)("Client connected with generated client id = " + client.clientId()));
            async.countDown();
        });
        async.await();
    }

    @Test
    public void afterConnectClientId(TestContext context) {
        Async async = context.async();
        MqttClientOptions options = new MqttClientOptions();
        options.setClientId("myClient");
        MqttClient client = MqttClient.create((Vertx)Vertx.vertx(), (MqttClientOptions)options);
        client.connect(this.port, this.host, c -> {
            Assert.assertTrue((boolean)c.succeeded());
            Assert.assertThat((Object)client.clientId(), (Matcher)IsNull.notNullValue());
            TestCase.assertFalse((boolean)client.clientId().isEmpty());
            Assert.assertEquals((Object)client.clientId(), (Object)"myClient");
            log.info((Object)("Client connected with requested client id = " + client.clientId()));
            async.countDown();
        });
        async.await();
    }
}

