/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mqtt.it;

import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.mqtt.MqttClient;
import io.vertx.mqtt.MqttClientOptions;
import io.vertx.mqtt.it.MqttClientBaseIT;
import org.junit.Assert;
import org.junit.Test;

public class MqttClientMaxMessageSizeIT
extends MqttClientBaseIT {
    private static final Logger log = LoggerFactory.getLogger(MqttClientMaxMessageSizeIT.class);
    private static final String MQTT_TOPIC = "/my_topic";
    private static final int MQTT_MAX_MESSAGE_SIZE = 50;
    private static final int MQTT_BIG_MESSAGE_SIZE = 51;

    @Test
    public void decoderMaxMessageSize(TestContext context) throws InterruptedException {
        Async async = context.async();
        MqttClient client = MqttClient.create((Vertx)Vertx.vertx(), (MqttClientOptions)new MqttClientOptions().setMaxMessageSize(50));
        client.subscribeCompletionHandler(sc -> {
            log.info((Object)"SUBACK <---");
            byte[] message = new byte[51];
            client.publish(MQTT_TOPIC, Buffer.buffer((byte[])message), MqttQoS.AT_MOST_ONCE, false, false);
            log.info((Object)"PUBLISH ---> ... with big message size which should cause decoder exception");
        });
        client.exceptionHandler(t -> {
            log.error((Object)"Exception raised", t);
            if (t instanceof DecoderException) {
                log.info((Object)"PUBLISH <--- message with big size");
                async.countDown();
            }
        });
        log.info((Object)"CONNECT --->");
        client.connect(this.port, this.host, c -> {
            Assert.assertTrue((boolean)c.succeeded());
            log.info((Object)"CONNACK <---");
            client.subscribe(MQTT_TOPIC, 0);
            log.info((Object)"SUBSCRIBE --->");
        });
        async.await();
    }
}

