/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mqtt.it;

import io.vertx.core.Vertx;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.mqtt.MqttClient;
import io.vertx.mqtt.MqttClientOptions;
import io.vertx.mqtt.it.MqttClientBaseIT;
import org.junit.Assert;
import org.junit.Test;

public class MqttClientPingIT
extends MqttClientBaseIT {
    private static final Logger log = LoggerFactory.getLogger(MqttClientPingIT.class);
    private static final int PING_NUMBER = 3;
    private static final int KEEPALIVE_TIMEOUT = 2;
    private int count = 0;
    private long timerId = 0L;

    @Test
    public void manualPing(TestContext context) throws InterruptedException {
        Vertx vertx = Vertx.vertx();
        Async async = context.async();
        MqttClientOptions options = new MqttClientOptions();
        options.setAutoKeepAlive(false);
        log.info((Object)"Manual ping ... 3 times timeout 2");
        this.count = 0;
        MqttClient client = MqttClient.create((Vertx)vertx, (MqttClientOptions)options);
        client.connect(this.port, this.host, c -> {
            Assert.assertTrue((boolean)c.succeeded());
            client.pingResponseHandler(v -> {
                log.info((Object)"Pingresp <-- ");
                ++this.count;
                if (this.count == 3) {
                    vertx.cancelTimer(this.timerId);
                    client.disconnect();
                    async.countDown();
                }
            });
            vertx.setPeriodic(2000L, t -> {
                this.timerId = t;
                log.info((Object)"Pingreq --> ");
                client.ping();
            });
        });
        async.await();
    }

    @Test
    public void autoPing(TestContext context) throws InterruptedException {
        Async async = context.async();
        MqttClientOptions options = new MqttClientOptions();
        options.setKeepAliveInterval(2);
        log.info((Object)"Auto ping ... 3 times timeout 2");
        this.count = 0;
        MqttClient client = MqttClient.create((Vertx)Vertx.vertx(), (MqttClientOptions)options);
        client.connect(this.port, this.host, c -> {
            Assert.assertTrue((boolean)c.succeeded());
            client.pingResponseHandler(v -> {
                log.info((Object)"Pingresp <-- ");
                ++this.count;
                if (this.count == 3) {
                    client.disconnect();
                    async.countDown();
                }
            });
        });
        async.await();
    }
}

