/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mqtt.it;

import io.netty.handler.codec.mqtt.MqttQoS;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.mqtt.MqttClient;
import io.vertx.mqtt.it.MqttClientBaseIT;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class MqttClientPublishIT
extends MqttClientBaseIT {
    private static final Logger log = LoggerFactory.getLogger(MqttClientPublishIT.class);
    private static final String MQTT_TOPIC = "/my_topic";
    private static final String MQTT_MESSAGE = "Hello Vert.x MQTT Client";
    private int messageId = 0;

    @Test
    public void publishQoS2(TestContext context) throws InterruptedException {
        this.publish(context, MqttQoS.EXACTLY_ONCE);
    }

    @Test
    public void publishQoS1(TestContext context) throws InterruptedException {
        this.publish(context, MqttQoS.AT_LEAST_ONCE);
    }

    private void publish(TestContext context, MqttQoS qos) {
        this.messageId = 0;
        Async async = context.async();
        MqttClient client = MqttClient.create((Vertx)Vertx.vertx());
        client.publishCompletionHandler(pubid -> {
            Assert.assertTrue((pubid == this.messageId ? 1 : 0) != 0);
            log.info((Object)("publishing complete for message id = " + pubid));
            client.disconnect();
            async.countDown();
        });
        client.connect(this.port, this.host, ar -> {
            Assert.assertTrue((boolean)ar.succeeded());
            client.publish(MQTT_TOPIC, Buffer.buffer((byte[])MQTT_MESSAGE.getBytes()), qos, false, false, ar1 -> {
                Assert.assertTrue((boolean)ar.succeeded());
                this.messageId = (Integer)ar1.result();
                log.info((Object)("publishing message id = " + this.messageId));
            });
        });
        async.await();
    }
}

