/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mqtt.it;

import io.netty.handler.codec.mqtt.MqttQoS;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.mqtt.MqttClient;
import io.vertx.mqtt.it.MqttClientBaseIT;
import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;

public class MqttClientTopicValidationIT
extends MqttClientBaseIT {
    private static final Logger log = LoggerFactory.getLogger(MqttClientTopicValidationIT.class);
    private static final String MQTT_MESSAGE = "Hello Vert.x MQTT Client";
    private static final int MAX_TOPIC_LEN = 65535;
    private static final String goodTopic;
    private static final String badTopic;

    @Test
    public void topicNameValidation(TestContext context) {
        this.testPublish("/", true, context);
        this.testPublish("/hello", true, context);
        this.testPublish("sport/tennis/player1", true, context);
        this.testPublish("sport/tennis/player1#", false, context);
        this.testPublish("sport/tennis/+/player1#", false, context);
        this.testPublish("#", false, context);
        this.testPublish("+", false, context);
        this.testPublish("", false, context);
        this.testPublish(goodTopic, true, context);
        this.testPublish(badTopic, false, context);
    }

    @Test
    public void topicFilterValidation(TestContext context) {
        this.testSubscribe("#", true, context);
        this.testSubscribe("+", true, context);
        this.testSubscribe("+/tennis/#", true, context);
        this.testSubscribe("sport/+/player1", true, context);
        this.testSubscribe("+/+", true, context);
        this.testSubscribe("sport+", false, context);
        this.testSubscribe("sp#ort", false, context);
        this.testSubscribe("+/tennis#", false, context);
        this.testSubscribe(goodTopic, true, context);
        this.testSubscribe(badTopic, false, context);
    }

    public void testPublish(String topicName, boolean mustBeValid, TestContext context) {
        log.info((Object)String.format("test publishing in \"%s\" topic", topicName));
        Async async = context.async(2);
        MqttClient client = MqttClient.create((Vertx)Vertx.vertx());
        client.connect(this.port, this.host, c -> {
            Assert.assertTrue((boolean)c.succeeded());
            client.publish(topicName, Buffer.buffer((byte[])MQTT_MESSAGE.getBytes()), MqttQoS.AT_MOST_ONCE, false, false, ar1 -> {
                Assert.assertThat((Object)ar1.succeeded(), (Matcher)Is.is((Object)mustBeValid));
                log.info((Object)("publishing message id = " + ar1.result()));
                async.countDown();
                client.disconnect(ar -> {
                    Assert.assertTrue((boolean)ar.succeeded());
                    async.countDown();
                });
            });
        });
        async.await();
    }

    public void testSubscribe(String topicFilter, boolean mustBeValid, TestContext context) {
        log.info((Object)String.format("test subscribing for \"%s\" topic", topicFilter));
        Async async = context.async(2);
        MqttClient client = MqttClient.create((Vertx)Vertx.vertx());
        client.connect(this.port, this.host, c -> {
            Assert.assertTrue((boolean)c.succeeded());
            client.subscribe(topicFilter, 0, ar -> {
                Assert.assertThat((Object)ar.succeeded(), (Matcher)Is.is((Object)mustBeValid));
                log.info((Object)("subscribe message id = " + ar.result()));
                async.countDown();
                client.disconnect(ar1 -> {
                    Assert.assertTrue((boolean)ar1.succeeded());
                    async.countDown();
                });
            });
        });
        async.await();
    }

    static {
        char[] topic = new char[65536];
        Arrays.fill(topic, 'h');
        badTopic = new String(topic);
        goodTopic = new String(topic, 0, 65535);
    }
}

