/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mqtt.it;

import io.netty.handler.codec.mqtt.MqttQoS;
import io.vertx.core.Vertx;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.mqtt.MqttClient;
import io.vertx.mqtt.it.MqttClientBaseIT;
import org.junit.Assert;
import org.junit.Test;

public class MqttClientUnsubscribeIT
extends MqttClientBaseIT {
    private static final Logger log = LoggerFactory.getLogger(MqttClientUnsubscribeIT.class);
    private static final String MQTT_TOPIC = "/my_topic";
    private int messageId = 0;

    @Test
    public void unsubscribeQoS0(TestContext context) throws InterruptedException {
        this.unsubscribe(context, MqttQoS.AT_MOST_ONCE);
    }

    @Test
    public void unsubscribeQoS1(TestContext context) throws InterruptedException {
        this.unsubscribe(context, MqttQoS.AT_LEAST_ONCE);
    }

    @Test
    public void unsubscribeQoS2(TestContext context) throws InterruptedException {
        this.unsubscribe(context, MqttQoS.EXACTLY_ONCE);
    }

    private void unsubscribe(TestContext context, MqttQoS qos) {
        this.messageId = 0;
        Async async = context.async();
        MqttClient client = MqttClient.create((Vertx)Vertx.vertx());
        client.unsubscribeCompletionHandler(unsubackid -> {
            Assert.assertTrue((unsubackid == this.messageId ? 1 : 0) != 0);
            log.info((Object)("unsubscribing complete for message id = " + unsubackid));
            client.disconnect();
            async.countDown();
        });
        client.subscribeCompletionHandler(suback -> {
            Assert.assertTrue((suback.messageId() == this.messageId ? 1 : 0) != 0);
            Assert.assertTrue((boolean)suback.grantedQoSLevels().contains(qos.value()));
            log.info((Object)("subscribing complete for message id = " + suback.messageId() + " with QoS " + suback.grantedQoSLevels()));
            client.unsubscribe(MQTT_TOPIC, ar2 -> {
                Assert.assertTrue((boolean)ar2.succeeded());
                this.messageId = (Integer)ar2.result();
                log.info((Object)("unsubscribing on [/my_topic] message id = " + this.messageId));
            });
        });
        client.connect(this.port, this.host, ar -> {
            Assert.assertTrue((boolean)ar.succeeded());
            client.subscribe(MQTT_TOPIC, qos.value(), ar1 -> {
                Assert.assertTrue((boolean)ar1.succeeded());
                this.messageId = (Integer)ar1.result();
                log.info((Object)("subscribing on [/my_topic] with QoS [" + qos.value() + "] message id = " + this.messageId));
            });
        });
        async.await();
    }
}

