/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mqtt.test.server;

import io.netty.handler.codec.mqtt.MqttProperties;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.mqtt.MqttEndpoint;
import io.vertx.mqtt.test.server.MqttServerBaseTest;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import org.eclipse.paho.mqttv5.client.MqttClient;
import org.eclipse.paho.mqttv5.client.MqttClientPersistence;
import org.eclipse.paho.mqttv5.client.persist.MemoryPersistence;
import org.eclipse.paho.mqttv5.common.MqttException;
import org.eclipse.paho.mqttv5.common.MqttMessage;
import org.eclipse.paho.mqttv5.common.packet.MqttProperties;
import org.eclipse.paho.mqttv5.common.packet.UserProperty;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class Mqtt5ServerClientPublishTest
extends MqttServerBaseTest {
    private static final Logger log = LoggerFactory.getLogger(Mqtt5ServerClientPublishTest.class);
    private Async async;
    private String expectedMessage;
    private String expectedLabel;
    private static final String MQTT_TOPIC = "/my_topic";
    private static final String MQTT_MESSAGE = "Hello Vert.x MQTT Server";

    @Before
    public void before(TestContext context) {
        this.setUp(context);
    }

    @After
    public void after(TestContext context) {
        this.tearDown(context);
    }

    @Test
    public void publishQos0(TestContext context) {
        this.publish(context, MQTT_TOPIC, MQTT_MESSAGE, 0, "red");
    }

    @Test
    public void publishQos1(TestContext context) {
        this.publish(context, MQTT_TOPIC, MQTT_MESSAGE, 1, "green");
    }

    @Test
    public void publishQos2(TestContext context) {
        this.publish(context, MQTT_TOPIC, MQTT_MESSAGE, 2, "blue");
    }

    private void publish(TestContext context, String topic, String message, int qos, String label) {
        this.async = context.async();
        try {
            MemoryPersistence persistence = new MemoryPersistence();
            MqttClient client = new MqttClient(String.format("tcp://%s:%d", "localhost", 1883), "12345", (MqttClientPersistence)persistence);
            client.connect();
            this.expectedMessage = message;
            this.expectedLabel = label;
            MqttProperties mqttProperties = new MqttProperties();
            mqttProperties.setUserProperties(Collections.singletonList(new UserProperty("label", label)));
            MqttMessage mqttMessage = new MqttMessage(message.getBytes(StandardCharsets.UTF_8), qos, false, mqttProperties);
            client.publish(topic, mqttMessage);
            this.async.await();
            context.assertTrue(true);
        }
        catch (MqttException e) {
            e.printStackTrace();
            context.assertTrue(false);
        }
    }

    @Override
    protected void endpointHandler(MqttEndpoint endpoint, TestContext context) {
        endpoint.publishHandler(message -> {
            String messageText = message.payload().toString(StandardCharsets.UTF_8);
            log.info((Object)("Just received message on [" + message.topicName() + "] payload [" + messageText + "] with QoS [" + message.qosLevel() + "]"));
            context.assertEquals((Object)this.expectedMessage, (Object)messageText);
            MqttProperties.UserProperties userProps = (MqttProperties.UserProperties)message.properties().getProperty(MqttProperties.MqttPropertyType.USER_PROPERTY.value());
            context.assertEquals((Object)1, (Object)((List)userProps.value()).size());
            context.assertEquals((Object)"label", (Object)((MqttProperties.StringPair)((List)userProps.value()).get((int)0)).key);
            context.assertEquals((Object)this.expectedLabel, (Object)((MqttProperties.StringPair)((List)userProps.value()).get((int)0)).value);
            switch (message.qosLevel()) {
                case AT_LEAST_ONCE: {
                    endpoint.publishAcknowledge(message.messageId());
                    this.async.complete();
                    break;
                }
                case EXACTLY_ONCE: {
                    endpoint.publishReceived(message.messageId());
                    break;
                }
                case AT_MOST_ONCE: {
                    this.async.complete();
                }
            }
        }).publishReleaseHandler(messageId -> {
            endpoint.publishComplete(messageId.intValue());
            this.async.complete();
        });
        endpoint.accept(false);
    }
}

