/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mqtt.test.server;

import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.mqtt.MqttEndpoint;
import io.vertx.mqtt.test.server.MqttServerBaseTest;
import org.eclipse.paho.mqttv5.client.MqttClient;
import org.eclipse.paho.mqttv5.client.MqttClientPersistence;
import org.eclipse.paho.mqttv5.client.persist.MemoryPersistence;
import org.eclipse.paho.mqttv5.common.MqttException;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class Mqtt5ServerDisconnectTest
extends MqttServerBaseTest {
    private static final Logger log = LoggerFactory.getLogger(Mqtt5ServerDisconnectTest.class);

    @Before
    public void before(TestContext context) {
        this.setUp(context);
    }

    @After
    public void after(TestContext context) {
        this.tearDown(context);
    }

    @Test
    public void disconnect(TestContext context) {
        try {
            MemoryPersistence persistence = new MemoryPersistence();
            MqttClient client = new MqttClient(String.format("tcp://%s:%d", "localhost", 1883), "12345", (MqttClientPersistence)persistence);
            client.connect();
            client.disconnect();
            context.assertTrue(true);
        }
        catch (MqttException e) {
            context.assertTrue(false);
            e.printStackTrace();
        }
    }

    @Test
    public void bruteDisconnect(TestContext context) {
        try {
            MemoryPersistence persistence = new MemoryPersistence();
            MqttClient client = new MqttClient(String.format("tcp://%s:%d", "localhost", 1883), "12345", (MqttClientPersistence)persistence);
            client.connect();
            client.close();
            context.assertTrue(false);
        }
        catch (MqttException e) {
            context.assertEquals((Object)e.getReasonCode(), (Object)32100);
            e.printStackTrace();
        }
    }

    @Override
    protected void endpointHandler(MqttEndpoint endpoint, TestContext context) {
        endpoint.disconnectHandler(v -> log.info((Object)"MQTT remote client disconnected"));
        endpoint.closeHandler(v -> log.info((Object)"MQTT remote client connection closed"));
        endpoint.accept(false);
    }
}

