/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mqtt.test.server;

import io.netty.handler.codec.mqtt.MqttProperties;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.mqtt.MqttEndpoint;
import io.vertx.mqtt.messages.codes.MqttDisconnectReasonCode;
import io.vertx.mqtt.test.server.Mqtt5ProbeCallback;
import io.vertx.mqtt.test.server.MqttServerBaseTest;
import org.eclipse.paho.mqttv5.client.MqttCallback;
import org.eclipse.paho.mqttv5.client.MqttClient;
import org.eclipse.paho.mqttv5.client.MqttClientPersistence;
import org.eclipse.paho.mqttv5.client.persist.MemoryPersistence;
import org.eclipse.paho.mqttv5.common.MqttException;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class Mqtt5ServerEndpointStatusTest
extends MqttServerBaseTest {
    private static final Logger log = LoggerFactory.getLogger(Mqtt5ServerEndpointStatusTest.class);
    private MqttEndpoint endpoint;

    @Before
    public void before(TestContext context) {
        this.setUp(context);
    }

    @After
    public void after(TestContext context) {
        this.tearDown(context);
    }

    @Test
    public void connected(TestContext context) {
        try {
            MemoryPersistence persistence = new MemoryPersistence();
            MqttClient client = new MqttClient(String.format("tcp://%s:%d", "localhost", 1883), "12345", (MqttClientPersistence)persistence);
            client.connect();
            context.assertTrue(client.isConnected() && this.endpoint.isConnected());
        }
        catch (MqttException e) {
            context.assertTrue(false);
            e.printStackTrace();
        }
    }

    @Test
    public void disconnectedByClient(TestContext context) {
        Async async = context.async();
        try {
            MemoryPersistence persistence = new MemoryPersistence();
            MqttClient client = new MqttClient(String.format("tcp://%s:%d", "localhost", 1883), "12345", (MqttClientPersistence)persistence);
            client.connect();
            client.disconnect();
            this.vertx.setTimer(1000L, t1 -> async.complete());
            async.await();
            context.assertTrue(!client.isConnected() && !this.endpoint.isConnected());
        }
        catch (MqttException e) {
            context.assertTrue(false);
            e.printStackTrace();
        }
    }

    @Test
    public void disconnectedByServer(TestContext context) throws InterruptedException {
        Async async = context.async();
        try {
            MemoryPersistence persistence = new MemoryPersistence();
            MqttClient client = new MqttClient(String.format("tcp://%s:%d", "localhost", 1883), "12345", (MqttClientPersistence)persistence);
            Mqtt5ProbeCallback callback = new Mqtt5ProbeCallback(context);
            client.setCallback((MqttCallback)callback);
            client.connect();
            this.vertx.setTimer(1000L, t -> {
                this.endpoint.disconnect(MqttDisconnectReasonCode.SERVER_SHUTTING_DOWN, MqttProperties.NO_PROPERTIES);
                async.complete();
            });
            async.await();
            for (int attempt = 0; attempt < 5 && client.isConnected(); ++attempt) {
                Thread.sleep(10L);
            }
            context.assertTrue(!client.isConnected() && !this.endpoint.isConnected());
            context.assertNotNull((Object)callback.getDisconnectResponse());
            context.assertEquals((Object)callback.getDisconnectResponse().getReturnCode(), (Object)139);
        }
        catch (MqttException e) {
            context.assertTrue(false);
            e.printStackTrace();
        }
    }

    @Override
    protected void endpointHandler(MqttEndpoint endpoint, TestContext context) {
        this.endpoint = endpoint;
        endpoint.disconnectHandler(v -> log.info((Object)"MQTT remote client disconnected"));
        endpoint.accept(false);
    }
}

