/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mqtt.test.server;

import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.mqtt.MqttProperties;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.mqtt.MqttEndpoint;
import io.vertx.mqtt.MqttServerOptions;
import io.vertx.mqtt.messages.codes.MqttDisconnectReasonCode;
import io.vertx.mqtt.test.server.Mqtt5ProbeCallback;
import io.vertx.mqtt.test.server.MqttServerBaseTest;
import org.eclipse.paho.mqttv5.client.MqttCallback;
import org.eclipse.paho.mqttv5.client.MqttClient;
import org.eclipse.paho.mqttv5.client.MqttClientPersistence;
import org.eclipse.paho.mqttv5.client.persist.MemoryPersistence;
import org.eclipse.paho.mqttv5.common.MqttException;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class Mqtt5ServerMaxMessageSizeTest
extends MqttServerBaseTest {
    private static final Logger log = LoggerFactory.getLogger(Mqtt5ServerMaxMessageSizeTest.class);
    private static final String MQTT_TOPIC = "/my_topic";
    private static final int MQTT_MAX_MESSAGE_SIZE = 50;
    private static final int MQTT_BIG_MESSAGE_SIZE = 51;

    @Before
    public void before(TestContext context) {
        MqttServerOptions options = new MqttServerOptions();
        options.setMaxMessageSize(50);
        this.setUp(context, options);
    }

    @Ignore
    @Test
    public void publishBigMessage(TestContext context) {
        Mqtt5ProbeCallback probeCallback = new Mqtt5ProbeCallback(context);
        try {
            MemoryPersistence persistence = new MemoryPersistence();
            MqttClient client = new MqttClient(String.format("tcp://%s:%d", "localhost", 1883), "12345", (MqttClientPersistence)persistence);
            client.setCallback((MqttCallback)probeCallback);
            client.connect();
            byte[] message = new byte[51];
            client.setTimeToWait(1000L);
            client.publish(MQTT_TOPIC, message, 0, false);
        }
        catch (MqttException e) {
            log.info((Object)"MQTT client failure", (Throwable)e);
        }
        context.assertEquals((Object)149, (Object)probeCallback.getDisconnectResponse().getReturnCode());
    }

    @After
    public void after(TestContext context) {
        this.tearDown(context);
    }

    @Override
    protected void endpointHandler(MqttEndpoint endpoint, TestContext context) {
        endpoint.exceptionHandler(t -> {
            if (t instanceof TooLongFrameException) {
                endpoint.disconnect(MqttDisconnectReasonCode.PACKET_TOO_LARGE, MqttProperties.NO_PROPERTIES);
            }
        });
        endpoint.accept(false);
    }
}

