/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mqtt.test.server;

import io.netty.handler.codec.mqtt.MqttProperties;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.mqtt.MqttEndpoint;
import io.vertx.mqtt.MqttTopicSubscription;
import io.vertx.mqtt.messages.codes.MqttUnsubAckReasonCode;
import io.vertx.mqtt.test.server.MqttServerBaseTest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.paho.mqttv5.client.MqttClient;
import org.eclipse.paho.mqttv5.client.MqttClientPersistence;
import org.eclipse.paho.mqttv5.client.persist.MemoryPersistence;
import org.eclipse.paho.mqttv5.common.MqttException;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class Mqtt5ServerUnsubscribeTest
extends MqttServerBaseTest {
    private static final Logger log = LoggerFactory.getLogger(Mqtt5ServerUnsubscribeTest.class);
    private List<MqttUnsubAckReasonCode> expectedReasonCodes;
    private static final String MQTT_TOPIC = "/my_topic";
    private static final String MQTT_REASON_STRING = "because I've said so";

    @Before
    public void before(TestContext context) {
        this.setUp(context);
    }

    @After
    public void after(TestContext context) {
        this.tearDown(context);
    }

    @Test
    public void unsubscribe(TestContext context) {
        try {
            MemoryPersistence persistence = new MemoryPersistence();
            MqttClient client = new MqttClient(String.format("tcp://%s:%d", "localhost", 1883), "12345", (MqttClientPersistence)persistence);
            client.connect();
            this.expectedReasonCodes = Collections.singletonList(MqttUnsubAckReasonCode.SUCCESS);
            String[] topics = new String[]{MQTT_TOPIC};
            int[] qos = new int[]{0};
            client.subscribe(topics, qos);
            client.unsubscribe(topics);
            context.assertTrue(true);
        }
        catch (MqttException e) {
            context.fail((Throwable)e);
        }
    }

    @Test
    public void unsubscribeFail(TestContext context) {
        try {
            MemoryPersistence persistence = new MemoryPersistence();
            MqttClient client = new MqttClient(String.format("tcp://%s:%d", "localhost", 1883), "12345", (MqttClientPersistence)persistence);
            client.connect();
            this.expectedReasonCodes = Collections.singletonList(MqttUnsubAckReasonCode.IMPLEMENTATION_SPECIFIC_ERROR);
            String[] topics = new String[]{MQTT_TOPIC};
            int[] qos = new int[]{0};
            client.subscribe(topics, qos);
            client.unsubscribe(topics);
        }
        catch (MqttException e) {
            context.assertEquals((Object)131, (Object)e.getReasonCode());
            context.assertEquals((Object)MQTT_REASON_STRING, (Object)e.getMessage());
        }
    }

    @Override
    protected void endpointHandler(MqttEndpoint endpoint, TestContext context) {
        endpoint.subscribeHandler(subscribe -> {
            ArrayList<MqttQoS> qos = new ArrayList<MqttQoS>();
            qos.add(((MqttTopicSubscription)subscribe.topicSubscriptions().get(0)).qualityOfService());
            endpoint.subscribeAcknowledge(subscribe.messageId(), qos);
        }).unsubscribeHandler(unsubscribe -> {
            MqttProperties props = new MqttProperties();
            if (this.expectedReasonCodes.get(0) != MqttUnsubAckReasonCode.SUCCESS) {
                props.add((MqttProperties.MqttProperty)new MqttProperties.StringProperty(MqttProperties.MqttPropertyType.REASON_STRING.value(), MQTT_REASON_STRING));
            }
            endpoint.unsubscribeAcknowledge(unsubscribe.messageId(), this.expectedReasonCodes, props);
        });
        endpoint.accept(false);
    }
}

