/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mqtt.test.server;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.mqtt.MqttConnectPayload;
import io.netty.handler.codec.mqtt.MqttConnectVariableHeader;
import io.netty.handler.codec.mqtt.MqttEncoder;
import io.netty.handler.codec.mqtt.MqttFixedHeader;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageFactory;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import io.netty.handler.codec.mqtt.MqttPublishVariableHeader;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.netty.util.CharsetUtil;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetSocket;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.mqtt.MqttClientOptions;
import io.vertx.mqtt.test.server.MqttServerBaseTest;
import java.nio.charset.StandardCharsets;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class MqttServerBadClientTest
extends MqttServerBaseTest {
    private static final String PROTOCOL_NAME = "MQTT";
    private static final int PROTOCOL_VERSION = 4;
    private static final String MQTT_TOPIC = "/my_topic";
    private static final String MQTT_MESSAGE = "I'm a bad client";
    private final ByteBufAllocator ALLOCATOR = new UnpooledByteBufAllocator(false);

    @Before
    public void before(TestContext context) {
        this.setUp(context);
    }

    @After
    public void after(TestContext context) {
        this.tearDown(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void multipleConnect(TestContext context) throws InterruptedException {
        this.mqttServer.exceptionHandler(t -> context.assertTrue(false));
        NioEventLoopGroup group = new NioEventLoopGroup();
        try {
            Bootstrap bootstrap = new Bootstrap();
            ((Bootstrap)((Bootstrap)bootstrap.group((EventLoopGroup)group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) throws Exception {
                    ChannelPipeline pipeline = ch.pipeline();
                    pipeline.addLast("mqttEncoder", (ChannelHandler)MqttEncoder.INSTANCE);
                }
            });
            ChannelFuture f = bootstrap.connect("localhost", 1883).sync();
            long tick = System.currentTimeMillis();
            MqttClientOptions options = new MqttClientOptions();
            f.channel().writeAndFlush((Object)this.createConnectPacket(options)).sync();
            f.channel().writeAndFlush((Object)this.createConnectPacket(options)).sync();
            f.channel().closeFuture().sync();
            long tock = System.currentTimeMillis();
            context.assertTrue((tock - tick) / 1000L < 90L);
        }
        finally {
            group.shutdownGracefully();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void noConnectTest(TestContext context) throws Exception {
        NioEventLoopGroup group = new NioEventLoopGroup();
        try {
            Bootstrap bootstrap = new Bootstrap();
            ((Bootstrap)((Bootstrap)bootstrap.group((EventLoopGroup)group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) throws Exception {
                    ChannelPipeline pipeline = ch.pipeline();
                    pipeline.addLast("mqttEncoder", (ChannelHandler)MqttEncoder.INSTANCE);
                }
            });
            ChannelFuture f = bootstrap.connect("localhost", 1883).sync();
            f.channel().writeAndFlush((Object)this.createPublishMessage());
            f.channel().closeFuture().sync();
            context.assertTrue(true);
        }
        finally {
            group.shutdownGracefully();
        }
    }

    @Test
    public void unknownMessageType(TestContext context) {
        NetClient client = this.vertx.createNetClient();
        Async async = context.async();
        client.connect(1883, "localhost", done -> {
            if (done.succeeded()) {
                byte[] packet = new byte[]{-16, 0};
                ((NetSocket)done.result()).write((Object)Buffer.buffer((byte[])packet));
                ((NetSocket)done.result()).closeHandler(v -> async.complete());
            } else {
                context.fail();
            }
        });
        async.await();
    }

    private MqttPublishMessage createPublishMessage() {
        MqttFixedHeader mqttFixedHeader = new MqttFixedHeader(MqttMessageType.PUBLISH, false, MqttQoS.AT_LEAST_ONCE, true, 0);
        MqttPublishVariableHeader mqttPublishVariableHeader = new MqttPublishVariableHeader(MQTT_TOPIC, 1);
        ByteBuf payload = this.ALLOCATOR.buffer();
        payload.writeBytes(MQTT_MESSAGE.getBytes(CharsetUtil.UTF_8));
        return new MqttPublishMessage(mqttFixedHeader, mqttPublishVariableHeader, payload);
    }

    private MqttMessage createConnectPacket(MqttClientOptions options) {
        MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.CONNECT, false, MqttQoS.AT_MOST_ONCE, false, 0);
        MqttConnectVariableHeader variableHeader = new MqttConnectVariableHeader(PROTOCOL_NAME, 4, options.hasUsername(), options.hasPassword(), options.isWillRetain(), options.getWillQoS(), options.isWillFlag(), options.isCleanSession(), options.getKeepAliveInterval());
        MqttConnectPayload payload = new MqttConnectPayload(options.getClientId() == null ? "" : options.getClientId(), options.getWillTopic(), options.getWillMessage() != null ? options.getWillMessage().getBytes(StandardCharsets.UTF_8) : null, options.hasUsername() ? options.getUsername() : null, options.hasPassword() ? options.getPassword().getBytes(StandardCharsets.UTF_8) : null);
        return MqttMessageFactory.newMessage((MqttFixedHeader)fixedHeader, (Object)variableHeader, (Object)payload);
    }
}

