/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mqtt.test.server;

import io.vertx.core.Vertx;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.mqtt.MqttEndpoint;
import io.vertx.mqtt.MqttServer;
import io.vertx.mqtt.MqttServerOptions;
import java.io.InputStream;
import java.security.KeyStore;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public abstract class MqttServerBaseTest {
    private static final Logger log = LoggerFactory.getLogger(MqttServerBaseTest.class);
    protected static final String MQTT_SERVER_HOST = "localhost";
    protected static final int MQTT_SERVER_PORT = 1883;
    protected static final int MQTT_SERVER_TLS_PORT = 8883;
    protected Vertx vertx;
    protected MqttServer mqttServer;
    protected Throwable rejection;

    protected void setUp(TestContext context, MqttServerOptions options) {
        this.vertx = Vertx.vertx();
        this.mqttServer = options == null ? MqttServer.create((Vertx)this.vertx) : MqttServer.create((Vertx)this.vertx, (MqttServerOptions)options);
        this.mqttServer.exceptionHandler(err -> {
            this.rejection = err;
        });
        Async async = context.async();
        this.mqttServer.endpointHandler(endpoint -> this.endpointHandler((MqttEndpoint)endpoint, context)).listen(context.asyncAssertSuccess(res -> {
            log.info((Object)("MQTT server listening on port " + res.actualPort()));
            async.complete();
        }));
        async.awaitSuccess(15000L);
    }

    protected void setUp(TestContext context) {
        this.setUp(context, null);
    }

    protected void tearDown(TestContext context) {
        this.mqttServer.close(context.asyncAssertSuccess());
        this.vertx.close(context.asyncAssertSuccess());
    }

    protected void endpointHandler(MqttEndpoint endpoint, TestContext context) {
        endpoint.accept(false);
    }

    protected SSLSocketFactory getSocketFactory(String trustStoreName, String keyStoreName) throws Exception {
        InputStream clientTrustStoreInput = this.getClass().getResourceAsStream(trustStoreName);
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        trustStore.load(clientTrustStoreInput, "wibble".toCharArray());
        TrustManagerFactory tmf = TrustManagerFactory.getInstance("X509");
        tmf.init(trustStore);
        KeyManager[] keyManagers = null;
        if (keyStoreName != null) {
            InputStream clientKeyStoreInput = this.getClass().getResourceAsStream(keyStoreName);
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(clientKeyStoreInput, "wibble".toCharArray());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(keyStore, "wibble".toCharArray());
            keyManagers = kmf.getKeyManagers();
        }
        SSLContext context = SSLContext.getInstance("TLSv1.2");
        context.init(keyManagers, tmf.getTrustManagers(), null);
        return context.getSocketFactory();
    }
}

