/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mqtt.test.server;

import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.mqtt.MqttEndpoint;
import io.vertx.mqtt.test.server.MqttServerBaseTest;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class MqttServerClientIdentifierTest
extends MqttServerBaseTest {
    @Before
    public void before(TestContext context) {
        this.setUp(context);
    }

    @After
    public void after(TestContext context) {
        this.tearDown(context);
    }

    @Test
    public void testInvalidClientIdentifier(TestContext context) throws Exception {
        MemoryPersistence persistence = new MemoryPersistence();
        MqttClient client = new MqttClient(String.format("tcp://%s:%d", "localhost", 1883), "invalid-id-with-24-chars", (MqttClientPersistence)persistence);
        MqttConnectOptions options = new MqttConnectOptions();
        options.setMqttVersion(3);
        try {
            client.connect(options);
            context.assertTrue(false);
        }
        catch (MqttException ignore) {
            context.assertTrue(true);
        }
    }

    @Test
    public void testValidClientIdentifier(TestContext context) throws Exception {
        MemoryPersistence persistence = new MemoryPersistence();
        MqttClient client = new MqttClient(String.format("tcp://%s:%d", "localhost", 1883), "id-madeof-23-characters", (MqttClientPersistence)persistence);
        MqttConnectOptions options = new MqttConnectOptions();
        options.setMqttVersion(3);
        try {
            client.connect(options);
            context.assertTrue(true);
        }
        catch (MqttException ignore) {
            context.assertTrue(false);
        }
    }

    @Override
    protected void endpointHandler(MqttEndpoint endpoint, TestContext context) {
        endpoint.accept(false);
    }
}

