/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mqtt.test.server;

import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.mqtt.MqttEndpoint;
import io.vertx.mqtt.test.server.MqttServerBaseTest;
import java.nio.charset.Charset;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class MqttServerClientPublishTest
extends MqttServerBaseTest {
    private static final Logger log = LoggerFactory.getLogger(MqttServerClientPublishTest.class);
    private Async async;
    private static final String MQTT_TOPIC = "/my_topic";
    private static final String MQTT_MESSAGE = "Hello Vert.x MQTT Server";

    @Before
    public void before(TestContext context) {
        this.setUp(context);
    }

    @After
    public void after(TestContext context) {
        this.tearDown(context);
    }

    @Test
    public void publishQos0(TestContext context) {
        this.publish(context, MQTT_TOPIC, MQTT_MESSAGE, 0);
    }

    @Test
    public void publishQos1(TestContext context) {
        this.publish(context, MQTT_TOPIC, MQTT_MESSAGE, 1);
    }

    @Test
    public void publishQos2(TestContext context) {
        this.publish(context, MQTT_TOPIC, MQTT_MESSAGE, 2);
    }

    private void publish(TestContext context, String topic, String message, int qos) {
        this.async = context.async();
        try {
            MemoryPersistence persistence = new MemoryPersistence();
            MqttClient client = new MqttClient(String.format("tcp://%s:%d", "localhost", 1883), "12345", (MqttClientPersistence)persistence);
            client.connect();
            client.publish(topic, message.getBytes(), qos, false);
            this.async.await();
            context.assertTrue(true);
        }
        catch (MqttException e) {
            context.assertTrue(false);
            e.printStackTrace();
        }
    }

    @Override
    protected void endpointHandler(MqttEndpoint endpoint, TestContext context) {
        endpoint.publishHandler(message -> {
            log.info((Object)("Just received message on [" + message.topicName() + "] payload [" + message.payload().toString(Charset.defaultCharset()) + "] with QoS [" + message.qosLevel() + "]"));
            switch (message.qosLevel()) {
                case AT_LEAST_ONCE: {
                    endpoint.publishAcknowledge(message.messageId());
                    this.async.complete();
                    break;
                }
                case EXACTLY_ONCE: {
                    endpoint.publishReceived(message.messageId());
                    break;
                }
                case AT_MOST_ONCE: {
                    this.async.complete();
                }
            }
        }).publishReleaseHandler(messageId -> {
            endpoint.publishComplete(messageId.intValue());
            this.async.complete();
        });
        endpoint.accept(false);
    }
}

