/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mqtt.test.server;

import io.netty.handler.codec.mqtt.MqttConnectReturnCode;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetSocket;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.mqtt.MqttEndpoint;
import io.vertx.mqtt.MqttServerOptions;
import io.vertx.mqtt.test.server.MqttServerBaseTest;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class MqttServerConnectionTest
extends MqttServerBaseTest {
    private static final Logger log = LoggerFactory.getLogger(MqttServerConnectionTest.class);
    private MqttConnectReturnCode expectedReturnCode;
    private static final String MQTT_USERNAME = "username";
    private static final String MQTT_PASSWORD = "password";
    private static final int MQTT_TIMEOUT_ON_CONNECT = 5;
    private MqttEndpoint endpoint;

    @Before
    public void before(TestContext context) {
        MqttServerOptions options = new MqttServerOptions();
        options.setTimeoutOnConnect(5);
        this.setUp(context, options);
    }

    @After
    public void after(TestContext context) {
        this.tearDown(context);
    }

    @Test
    public void accepted(TestContext context) {
        this.expectedReturnCode = MqttConnectReturnCode.CONNECTION_ACCEPTED;
        try {
            MemoryPersistence persistence = new MemoryPersistence();
            MqttClient client = new MqttClient(String.format("tcp://%s:%d", "localhost", 1883), "12345", (MqttClientPersistence)persistence);
            client.connect();
        }
        catch (MqttException e) {
            context.fail((Throwable)e);
        }
    }

    @Test
    public void acceptedClientIdAutoGenerated(TestContext context) {
        this.expectedReturnCode = MqttConnectReturnCode.CONNECTION_ACCEPTED;
        try {
            MemoryPersistence persistence = new MemoryPersistence();
            MqttClient client = new MqttClient(String.format("tcp://%s:%d", "localhost", 1883), "", (MqttClientPersistence)persistence);
            client.connect();
        }
        catch (MqttException e) {
            context.fail((Throwable)e);
        }
    }

    @Test
    public void refusedIdentifierRejected(TestContext context) {
        this.expectedReturnCode = MqttConnectReturnCode.CONNECTION_REFUSED_IDENTIFIER_REJECTED;
        try {
            MemoryPersistence persistence = new MemoryPersistence();
            MqttClient client = new MqttClient(String.format("tcp://%s:%d", "localhost", 1883), "12345", (MqttClientPersistence)persistence);
            client.connect();
            context.fail();
        }
        catch (MqttException e) {
            context.assertTrue(e.getReasonCode() == 2);
        }
    }

    @Test
    public void refusedServerUnavailable(TestContext context) {
        this.expectedReturnCode = MqttConnectReturnCode.CONNECTION_REFUSED_SERVER_UNAVAILABLE;
        try {
            MemoryPersistence persistence = new MemoryPersistence();
            MqttClient client = new MqttClient(String.format("tcp://%s:%d", "localhost", 1883), "12345", (MqttClientPersistence)persistence);
            client.connect();
            context.fail();
        }
        catch (MqttException e) {
            context.assertTrue(e.getReasonCode() == 3);
        }
    }

    @Test
    public void refusedBadUsernamePassword(TestContext context) {
        this.expectedReturnCode = MqttConnectReturnCode.CONNECTION_REFUSED_BAD_USER_NAME_OR_PASSWORD;
        try {
            MemoryPersistence persistence = new MemoryPersistence();
            MqttConnectOptions options = new MqttConnectOptions();
            options.setUserName("wrong_username");
            options.setPassword("wrong_password".toCharArray());
            MqttClient client = new MqttClient(String.format("tcp://%s:%d", "localhost", 1883), "12345", (MqttClientPersistence)persistence);
            client.connect(options);
            context.fail();
        }
        catch (MqttException e) {
            context.assertTrue(e.getReasonCode() == 4);
        }
    }

    @Test
    public void refusedNotAuthorized(TestContext context) {
        this.expectedReturnCode = MqttConnectReturnCode.CONNECTION_REFUSED_NOT_AUTHORIZED;
        try {
            MemoryPersistence persistence = new MemoryPersistence();
            MqttClient client = new MqttClient(String.format("tcp://%s:%d", "localhost", 1883), "12345", (MqttClientPersistence)persistence);
            client.connect();
            context.fail();
        }
        catch (MqttException e) {
            context.assertTrue(e.getReasonCode() == 5);
        }
    }

    @Test
    public void refusedUnacceptableProtocolVersion(TestContext context) {
        this.expectedReturnCode = MqttConnectReturnCode.CONNECTION_REFUSED_UNACCEPTABLE_PROTOCOL_VERSION;
        try {
            MemoryPersistence persistence = new MemoryPersistence();
            MqttConnectOptions options = new MqttConnectOptions();
            options.setMqttVersion(3);
            MqttClient client = new MqttClient(String.format("tcp://%s:%d", "localhost", 1883), "12345", (MqttClientPersistence)persistence);
            client.connect(options);
            context.fail();
        }
        catch (MqttException e) {
            context.assertTrue(e.getReasonCode() == 1);
        }
    }

    @Test
    public void connectionAlreadyAccepted(TestContext context) throws Exception {
        this.expectedReturnCode = MqttConnectReturnCode.CONNECTION_ACCEPTED;
        MemoryPersistence persistence = new MemoryPersistence();
        MqttClient client = new MqttClient(String.format("tcp://%s:%d", "localhost", 1883), "12345", (MqttClientPersistence)persistence);
        client.connect();
        try {
            this.endpoint.accept(false);
            context.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void refusedClientIdZeroBytes(TestContext context) {
        this.expectedReturnCode = MqttConnectReturnCode.CONNECTION_REFUSED_IDENTIFIER_REJECTED;
        try {
            MemoryPersistence persistence = new MemoryPersistence();
            MqttConnectOptions options = new MqttConnectOptions();
            options.setCleanSession(false);
            options.setMqttVersion(4);
            MqttClient client = new MqttClient(String.format("tcp://%s:%d", "localhost", 1883), "", (MqttClientPersistence)persistence);
            client.connect(options);
            context.fail();
        }
        catch (MqttException e) {
            context.assertTrue(e.getReasonCode() == 2);
            context.assertNotNull((Object)this.rejection);
        }
    }

    @Test
    public void noConnectSent(TestContext context) {
        NetClient client = this.vertx.createNetClient();
        Async async = context.async();
        client.connect(1883, "localhost", done -> {
            if (done.succeeded()) {
                ((NetSocket)done.result()).closeHandler(v -> {
                    log.info((Object)"No CONNECT sent in 5 secs. Closing connection.");
                    async.complete();
                });
            } else {
                context.fail();
            }
        });
        async.await(5500L);
        if (!async.isCompleted()) {
            context.fail();
        }
    }

    @Override
    protected void endpointHandler(MqttEndpoint endpoint, TestContext context) {
        MqttConnectReturnCode returnCode = this.expectedReturnCode;
        switch (this.expectedReturnCode) {
            case CONNECTION_REFUSED_BAD_USER_NAME_OR_PASSWORD: {
                returnCode = endpoint.auth().getUsername().equals(MQTT_USERNAME) && endpoint.auth().getPassword().equals(MQTT_PASSWORD) ? MqttConnectReturnCode.CONNECTION_ACCEPTED : MqttConnectReturnCode.CONNECTION_REFUSED_BAD_USER_NAME_OR_PASSWORD;
                break;
            }
            case CONNECTION_REFUSED_UNACCEPTABLE_PROTOCOL_VERSION: {
                returnCode = endpoint.protocolVersion() == 4 ? MqttConnectReturnCode.CONNECTION_ACCEPTED : MqttConnectReturnCode.CONNECTION_REFUSED_UNACCEPTABLE_PROTOCOL_VERSION;
            }
        }
        log.info((Object)("return code = " + returnCode));
        if (returnCode == MqttConnectReturnCode.CONNECTION_ACCEPTED) {
            log.info((Object)("client id = " + endpoint.clientIdentifier()));
            endpoint.accept(false);
        } else {
            endpoint.reject(returnCode);
        }
        this.endpoint = endpoint;
    }
}

