/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mqtt.test.server;

import io.vertx.core.Vertx;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.mqtt.MqttClient;
import io.vertx.mqtt.MqttClientOptions;
import io.vertx.mqtt.MqttServer;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class MqttServerKeepAliveTest {
    private Vertx vertx;
    private MqttServer server;

    private void startServer(TestContext ctx) {
        Async async = ctx.async();
        this.server.listen(ctx.asyncAssertSuccess(server -> async.complete()));
        async.awaitSuccess(10000L);
    }

    @Before
    public void before(TestContext ctx) {
        this.vertx = Vertx.vertx();
        this.server = MqttServer.create((Vertx)this.vertx);
    }

    @After
    public void after(TestContext ctx) {
        this.server.close(ctx.asyncAssertSuccess(v -> this.vertx.close(ctx.asyncAssertSuccess())));
    }

    @Test
    public void serverWillDisconnectOnTimeout(TestContext ctx) {
        this.server.endpointHandler(endpoint -> {
            endpoint.accept(false);
            endpoint.pingHandler(v -> ctx.fail());
        });
        this.startServer(ctx);
        MqttClientOptions options = new MqttClientOptions();
        options.setAutoKeepAlive(false);
        options.setKeepAliveInterval(2);
        MqttClient client = MqttClient.create((Vertx)this.vertx, (MqttClientOptions)options);
        client.connect(1883, "localhost", ctx.asyncAssertSuccess(ack -> {
            Async async = ctx.async();
            client.closeHandler(v -> async.complete());
        }));
    }
}

