/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mqtt.test.server;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.mqtt.MqttEndpoint;
import io.vertx.mqtt.test.server.MqttServerBaseTest;
import io.vertx.mqtt.test.server.Proxy;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class MqttServerNetworkIssueTest
extends MqttServerBaseTest {
    private static final Logger log = LoggerFactory.getLogger(MqttServerNetworkIssueTest.class);
    private Proxy proxy;
    private long started;
    private long ended;

    @Before
    public void before(TestContext context) {
        this.setUp(context);
        this.proxy = new Proxy(this.vertx, "localhost", 1883);
        this.proxy.start((Handler<AsyncResult<Void>>)context.asyncAssertSuccess());
    }

    @After
    public void after(TestContext context) {
        this.tearDown(context);
        this.proxy.stop((Handler<AsyncResult<Void>>)context.asyncAssertSuccess());
    }

    @Test
    public void keepAliveTimeout(TestContext context) {
        final Async async = context.async();
        int keepAliveInterval = 6;
        int timeout = keepAliveInterval + keepAliveInterval / 2;
        try {
            MemoryPersistence persistence = new MemoryPersistence();
            MqttClient client = new MqttClient(String.format("tcp://%s:%d", "localhost", 18830), "12345", (MqttClientPersistence)persistence);
            MqttConnectOptions options = new MqttConnectOptions();
            options.setAutomaticReconnect(false);
            options.setKeepAliveInterval(keepAliveInterval);
            this.started = System.currentTimeMillis();
            client.setCallback(new MqttCallback(){

                public void connectionLost(Throwable throwable) {
                    MqttServerNetworkIssueTest.this.ended = System.currentTimeMillis();
                    log.info((Object)("Elapsed : " + (MqttServerNetworkIssueTest.this.ended - MqttServerNetworkIssueTest.this.started)));
                    async.complete();
                }

                public void messageArrived(String s, MqttMessage mqttMessage) throws Exception {
                }

                public void deliveryComplete(IMqttDeliveryToken iMqttDeliveryToken) {
                }
            });
            client.connect(options);
            this.vertx.setTimer(1000L, t -> this.proxy.pause());
            async.await();
            long elapsed = this.ended - this.started;
            context.assertTrue(elapsed > (long)(timeout * 1000 - 500) && elapsed < (long)(timeout * 1000 + 500), elapsed + " > " + (timeout * 1000 - 500) + " && " + elapsed + " < " + (timeout * 1000 + 500) + " != true");
        }
        catch (MqttException e) {
            context.fail((Throwable)e);
        }
    }

    @Override
    protected void endpointHandler(MqttEndpoint endpoint, TestContext context) {
        endpoint.closeHandler(v -> log.info((Object)"MQTT remote client connection closed"));
        endpoint.accept(false);
    }
}

