/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mqtt.test.server;

import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.mqtt.MqttEndpoint;
import io.vertx.mqtt.MqttServerOptions;
import io.vertx.mqtt.test.server.MqttServerBaseTest;
import io.vertx.test.tls.Cert;
import java.nio.charset.Charset;
import javax.net.SocketFactory;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class MqttServerSslTest
extends MqttServerBaseTest {
    private static final Logger log = LoggerFactory.getLogger(MqttServerSslTest.class);
    private Async async;
    private static final String MQTT_TOPIC = "/my_topic";
    private static final String MQTT_MESSAGE = "Hello Vert.x MQTT Server";

    @Before
    public void before(TestContext context) {
        MqttServerOptions options = new MqttServerOptions().setPort(8883).setKeyCertOptions((KeyCertOptions)Cert.SERVER_PEM_ROOT_CA.get()).setSsl(true);
        this.setUp(context, options);
    }

    @Test
    public void connection(TestContext context) {
        this.async = context.async();
        try {
            MemoryPersistence persistence = new MemoryPersistence();
            MqttClient client = new MqttClient(String.format("ssl://%s:%d", "localhost", 8883), "12345", (MqttClientPersistence)persistence);
            MqttConnectOptions options = new MqttConnectOptions();
            options.setSocketFactory((SocketFactory)this.getSocketFactory("/tls/client-truststore-root-ca.jks", null));
            client.connect(options);
            client.publish(MQTT_TOPIC, MQTT_MESSAGE.getBytes(), 0, false);
            this.async.await();
            client.disconnect();
            context.assertTrue(true);
        }
        catch (MqttException e) {
            e.printStackTrace();
            context.assertTrue(false);
        }
        catch (Exception e1) {
            e1.printStackTrace();
            context.assertTrue(false);
        }
    }

    @After
    public void after(TestContext context) {
        this.tearDown(context);
    }

    @Override
    protected void endpointHandler(MqttEndpoint endpoint, TestContext context) {
        endpoint.publishHandler(message -> {
            log.info((Object)("Just received message on [" + message.topicName() + "] payload [" + message.payload().toString(Charset.defaultCharset()) + "] with QoS [" + message.qosLevel() + "]"));
            switch (message.qosLevel()) {
                case AT_LEAST_ONCE: {
                    endpoint.publishAcknowledge(message.messageId());
                    this.async.complete();
                    break;
                }
                case EXACTLY_ONCE: {
                    endpoint.publishReceived(message.messageId());
                    break;
                }
                case AT_MOST_ONCE: {
                    this.async.complete();
                }
            }
        }).publishReleaseHandler(messageId -> {
            endpoint.publishComplete(messageId.intValue());
            this.async.complete();
        });
        endpoint.accept(false);
    }
}

