/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mqtt.test.server;

import io.netty.handler.codec.mqtt.MqttQoS;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.NetClient;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.mqtt.MqttEndpoint;
import io.vertx.mqtt.MqttTopicSubscription;
import io.vertx.mqtt.test.server.MqttServerBaseTest;
import java.util.ArrayList;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class MqttServerSubscribeTest
extends MqttServerBaseTest {
    private static final Logger log = LoggerFactory.getLogger(MqttServerSubscribeTest.class);
    private Async async;
    private static final String MQTT_TOPIC = "/my_topic";
    private static final String MQTT_TOPIC_FAILURE = "/my_topic/failure";

    @Before
    public void before(TestContext context) {
        this.setUp(context);
    }

    @After
    public void after(TestContext context) {
        this.tearDown(context);
    }

    @Test
    public void subscribeQos0(TestContext context) {
        this.subscribe(context, MQTT_TOPIC, 0);
    }

    @Test
    public void subscribeQos1(TestContext context) {
        this.subscribe(context, MQTT_TOPIC, 1);
    }

    @Test
    public void subscribeQos2(TestContext context) {
        this.subscribe(context, MQTT_TOPIC, 2);
    }

    @Test
    public void subscribeFailure(TestContext context) {
        this.subscribe(context, MQTT_TOPIC_FAILURE, 0);
    }

    private void subscribe(TestContext context, String topic, int expectedQos) {
        this.async = context.async();
        try {
            MemoryPersistence persistence = new MemoryPersistence();
            MqttClient client = new MqttClient(String.format("tcp://%s:%d", "localhost", 1883), "12345", (MqttClientPersistence)persistence);
            client.connect();
            String[] topics = new String[]{topic};
            int[] qos = new int[]{expectedQos};
            client.subscribe(topics, qos);
            this.async.await();
            context.assertTrue(qos[0] == expectedQos);
        }
        catch (MqttException e) {
            context.assertTrue(topic.equals(MQTT_TOPIC_FAILURE));
            e.printStackTrace();
        }
    }

    @Test
    public void subscribeUnsupportedMqttVersion(TestContext context) {
        Async async = context.async();
        NetClient client = this.vertx.createNetClient();
        client.connect(1883, "localhost", context.asyncAssertSuccess(so -> {
            so.write((Object)Buffer.buffer((byte[])new byte[]{16, 17, 0, 4, 77, 81, 84, 84, 6, 2, 0, 60, 0, 5, 49, 50, 51, 52, 53}));
            Buffer received = Buffer.buffer();
            so.handler(arg_0 -> ((Buffer)received).appendBuffer(arg_0));
            so.exceptionHandler(arg_0 -> ((TestContext)context).fail(arg_0));
            so.closeHandler(v -> {
                Buffer expected = Buffer.buffer((byte[])new byte[]{32, 2, 0, 1});
                context.assertEquals((Object)expected, (Object)received);
                async.complete();
            });
        }));
    }

    @Override
    protected void endpointHandler(MqttEndpoint endpoint, TestContext context) {
        endpoint.subscribeHandler(subscribe -> {
            ArrayList<MqttQoS> qos = new ArrayList<MqttQoS>();
            MqttQoS grantedQos = ((MqttTopicSubscription)subscribe.topicSubscriptions().get(0)).topicName().equals(MQTT_TOPIC_FAILURE) ? MqttQoS.FAILURE : ((MqttTopicSubscription)subscribe.topicSubscriptions().get(0)).qualityOfService();
            qos.add(grantedQos);
            endpoint.subscribeAcknowledge(subscribe.messageId(), qos);
            this.async.complete();
        });
        endpoint.accept(false);
    }
}

