/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mqtt.test.server;

import io.netty.handler.codec.mqtt.MqttQoS;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.mqtt.MqttEndpoint;
import io.vertx.mqtt.MqttTopicSubscription;
import io.vertx.mqtt.test.server.MqttServerBaseTest;
import java.util.ArrayList;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class MqttServerUnsubscribeTest
extends MqttServerBaseTest {
    private static final Logger log = LoggerFactory.getLogger(MqttServerUnsubscribeTest.class);
    private Async subscribeAsync;
    private Async unsubscribeAsync;
    private static final String MQTT_TOPIC = "/my_topic";

    @Before
    public void before(TestContext context) {
        this.setUp(context);
    }

    @After
    public void after(TestContext context) {
        this.tearDown(context);
    }

    @Test
    public void unsubscribe(TestContext context) {
        this.subscribeAsync = context.async();
        this.unsubscribeAsync = context.async();
        try {
            MemoryPersistence persistence = new MemoryPersistence();
            MqttClient client = new MqttClient(String.format("tcp://%s:%d", "localhost", 1883), "12345", (MqttClientPersistence)persistence);
            client.connect();
            String[] topics = new String[]{MQTT_TOPIC};
            int[] qos = new int[]{0};
            client.subscribe(topics, qos);
            this.subscribeAsync.await();
            client.unsubscribe(topics);
            this.unsubscribeAsync.await();
            context.assertTrue(true);
        }
        catch (MqttException e) {
            context.assertTrue(false);
            e.printStackTrace();
        }
    }

    @Override
    protected void endpointHandler(MqttEndpoint endpoint, TestContext context) {
        endpoint.subscribeHandler(subscribe -> {
            ArrayList<MqttQoS> qos = new ArrayList<MqttQoS>();
            qos.add(((MqttTopicSubscription)subscribe.topicSubscriptions().get(0)).qualityOfService());
            endpoint.subscribeAcknowledge(subscribe.messageId(), qos);
            this.subscribeAsync.complete();
        }).unsubscribeHandler(unsubscribe -> {
            endpoint.unsubscribeAcknowledge(unsubscribe.messageId());
            this.unsubscribeAsync.complete();
        });
        endpoint.accept(false);
    }
}

