/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mqtt.test.server;

import io.netty.handler.codec.DecoderException;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.mqtt.MqttEndpoint;
import io.vertx.mqtt.MqttServerOptions;
import io.vertx.mqtt.test.server.MqttServerBaseTest;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class MqttServerWebSocketMaxMessageSizeTest
extends MqttServerBaseTest {
    private Async async;
    private static final String MQTT_TOPIC = "/my_topic";
    private static final int MQTT_MAX_MESSAGE_SIZE = 50;
    private static final int MQTT_BIG_MESSAGE_SIZE = 50;

    @Before
    public void before(TestContext context) {
        MqttServerOptions options = new MqttServerOptions();
        options.setMaxMessageSize(50);
        options.setUseWebSocket(true);
        this.setUp(context, options);
    }

    @Ignore
    @Test
    public void publishBigMessage(TestContext context) {
        this.async = context.async();
        try {
            MemoryPersistence persistence = new MemoryPersistence();
            MqttClient client = new MqttClient(String.format("ws://%s:%d", "localhost", 1883), "12345", (MqttClientPersistence)persistence);
            client.connect();
            byte[] message = new byte[50];
            client.setTimeToWait(1000L);
            client.publish(MQTT_TOPIC, message, 0, false);
        }
        catch (MqttException mqttException) {
            // empty catch block
        }
    }

    @After
    public void after(TestContext context) {
        this.tearDown(context);
    }

    @Override
    protected void endpointHandler(MqttEndpoint endpoint, TestContext context) {
        System.out.println("a");
        endpoint.exceptionHandler(t -> {
            System.out.println("b");
            if (t instanceof DecoderException) {
                this.async.complete();
            }
        });
        endpoint.accept(false);
    }
}

