/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mqtt.test.server;

import io.netty.handler.codec.mqtt.MqttProperties;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.mqtt.MqttClient;
import io.vertx.mqtt.MqttClientOptions;
import io.vertx.mqtt.MqttServer;
import io.vertx.mqtt.MqttServerOptions;
import io.vertx.mqtt.MqttWill;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class MqttServerWillTest {
    protected static final String MQTT_SERVER_HOST = "localhost";
    protected static final int MQTT_SERVER_PORT = 1883;
    private Vertx vertx;
    private MqttServer server;
    private MqttClient client;

    @Before
    public void before() {
        this.vertx = Vertx.vertx();
    }

    @After
    public void after(TestContext context) {
        MqttClient client;
        MqttServer server = this.server;
        if (server != null) {
            Async async = context.async();
            this.server = null;
            server.close(context.asyncAssertSuccess(v -> async.countDown()));
            async.await(20000L);
        }
        if ((client = this.client) != null) {
            Async async = context.async();
            this.client = null;
            client.disconnect(context.asyncAssertSuccess(v -> async.countDown()));
            async.await(20000L);
        }
        this.vertx.close(context.asyncAssertSuccess(v2 -> {
            this.vertx = null;
        }));
    }

    @Test
    public void testNullWill(TestContext context) {
        this.server = MqttServer.create((Vertx)this.vertx, (MqttServerOptions)new MqttServerOptions().setHost(MQTT_SERVER_HOST).setPort(1883));
        this.server.endpointHandler(endpoint -> {
            MqttWill will = endpoint.will();
            context.assertNull((Object)will.getWillMessage());
            endpoint.accept(false);
        });
        this.server.listen(context.asyncAssertSuccess(v -> {
            this.client = MqttClient.create((Vertx)this.vertx);
            this.client.connect(1883, MQTT_SERVER_HOST, context.asyncAssertSuccess(ack -> {}));
        }));
    }

    @Test
    public void testWill(TestContext context) {
        this.server = MqttServer.create((Vertx)this.vertx, (MqttServerOptions)new MqttServerOptions().setHost(MQTT_SERVER_HOST).setPort(1883));
        this.server.endpointHandler(endpoint -> {
            MqttWill will = endpoint.will();
            context.assertEquals((Object)Buffer.buffer((String)"the-message"), (Object)will.getWillMessage());
            context.assertEquals((Object)2, (Object)will.getWillQos());
            context.assertEquals((Object)"the-message", (Object)new String(will.getWillMessageBytes()));
            endpoint.accept(false);
        });
        this.server.listen(context.asyncAssertSuccess(v -> {
            this.client = MqttClient.create((Vertx)this.vertx, (MqttClientOptions)new MqttClientOptions().setWillFlag(true).setWillQoS(2).setWillMessage("the-message"));
            this.client.connect(1883, MQTT_SERVER_HOST, context.asyncAssertSuccess(ack -> {}));
        }));
    }

    @Test
    public void testToJson(TestContext context) {
        MqttProperties props1 = new MqttProperties();
        props1.add((MqttProperties.MqttProperty)new MqttProperties.StringProperty(MqttProperties.MqttPropertyType.CONTENT_TYPE.value(), "text/plain"));
        MqttWill will1 = new MqttWill(true, "/sample/topic", Buffer.buffer((String)"sample message"), 2, false, props1);
        JsonObject willJson = will1.toJson();
        MqttWill will2 = new MqttWill(willJson);
        context.assertEquals((Object)will1.getWillMessage(), (Object)will2.getWillMessage());
        context.assertEquals((Object)will1.getWillQos(), (Object)will2.getWillQos());
        context.assertEquals((Object)will1.getWillTopic(), (Object)will2.getWillTopic());
        MqttProperties props2 = will2.getWillProperties();
        context.assertEquals((Object)props1.listAll().size(), (Object)props2.listAll().size());
        for (MqttProperties.MqttProperty prop1 : props1.listAll()) {
            MqttProperties.MqttProperty prop2 = props2.getProperty(prop1.propertyId());
            context.assertNotNull((Object)prop2);
            context.assertEquals((Object)prop1, (Object)prop2);
        }
    }
}

