/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mqtt.test.server;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.net.SocketAddress;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.mqtt.MqttEndpoint;
import io.vertx.mqtt.MqttServerOptions;
import io.vertx.mqtt.test.server.MqttServerBaseTest;
import io.vertx.test.proxy.HAProxy;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class MqttServerWithProxyConnectionTest
extends MqttServerBaseTest {
    private static final Logger log = LoggerFactory.getLogger(MqttServerWithProxyConnectionTest.class);
    private static final String MQTT_USERNAME = "username";
    private static final String MQTT_PASSWORD = "password";
    private static final int MQTT_TIMEOUT_ON_CONNECT = 5;
    private static final int mockRemotePort = 12345;
    private static final String mockRemoteIp = "1.1.1.1";
    private static final int mockLocalPort = 54321;
    private static final String mockLocalIp = "10.10.10.10";
    private static final int haproxyDefaultPort = 11080;
    private MqttEndpoint endpoint;
    private HAProxy haProxy;

    @Before
    public void before(TestContext context) throws Exception {
        MqttServerOptions options = new MqttServerOptions().setUseProxyProtocol(true);
        options.setTimeoutOnConnect(5);
        this.setUp(context, options);
    }

    private void createHaproxy(HaproxyVersion version) throws Exception {
        this.haProxy = new HAProxy(SocketAddress.inetSocketAddress((int)1883, (String)"localhost"), version.header);
        this.haProxy.start(this.vertx);
        System.out.println(String.format("haproxy server with %s started", version.name()));
    }

    @After
    public void after(TestContext context) {
        this.tearDown(context);
        this.haProxy.stop();
        System.out.println("haproxy server stopped");
    }

    @Test
    public void testHaproxyV1TCP4(TestContext context) {
        try {
            this.createHaproxy(HaproxyVersion.V1_TCP4);
            MemoryPersistence persistence = new MemoryPersistence();
            MqttClient client = new MqttClient(String.format("tcp://%s:%d", "localhost", 11080), "12345", (MqttClientPersistence)persistence);
            client.connect();
            System.out.println("client remoteAddress: " + this.endpoint.remoteAddress());
            context.assertEquals((Object)this.endpoint.remoteAddress().host(), (Object)mockRemoteIp);
            context.assertEquals((Object)this.endpoint.remoteAddress().port(), (Object)12345);
            client.disconnect();
        }
        catch (Exception e) {
            context.fail((Throwable)e);
        }
    }

    @Test
    public void testHaproxyV2TCP4(TestContext context) {
        try {
            this.createHaproxy(HaproxyVersion.V2_TCP4);
            MemoryPersistence persistence = new MemoryPersistence();
            MqttClient client = new MqttClient(String.format("tcp://%s:%d", "localhost", 11080), "12345", (MqttClientPersistence)persistence);
            client.connect();
            System.out.println("client remoteAddress: " + this.endpoint.remoteAddress());
            context.assertEquals((Object)this.endpoint.remoteAddress().host(), (Object)mockRemoteIp);
            context.assertEquals((Object)this.endpoint.remoteAddress().port(), (Object)12345);
            client.disconnect();
        }
        catch (Exception e) {
            context.fail((Throwable)e);
        }
    }

    @Override
    protected void endpointHandler(MqttEndpoint endpoint, TestContext context) {
        super.endpointHandler(endpoint, context);
        this.endpoint = endpoint;
    }

    public static enum HaproxyVersion {
        V1_TCP4(HAProxy.createVersion2TCP4ProtocolHeader((SocketAddress)SocketAddress.inetSocketAddress((int)12345, (String)"1.1.1.1"), (SocketAddress)SocketAddress.inetSocketAddress((int)54321, (String)"10.10.10.10"))),
        V2_TCP4(HAProxy.createVersion2TCP4ProtocolHeader((SocketAddress)SocketAddress.inetSocketAddress((int)12345, (String)"1.1.1.1"), (SocketAddress)SocketAddress.inetSocketAddress((int)54321, (String)"10.10.10.10")));

        private final Buffer header;

        private HaproxyVersion(Buffer header) {
            this.header = header;
        }
    }
}

