/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mqtt.test.server;

import io.vertx.core.AsyncResult;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetServer;
import io.vertx.core.net.NetSocket;

public class Proxy {
    private static final Logger log = LoggerFactory.getLogger(Proxy.class);
    protected static final String SERVER_HOST = "localhost";
    protected static final int SERVER_PORT = 18830;
    private Vertx vertx;
    private String mqttServerHost;
    private int mqttServerPort;
    private NetServer server;
    private NetClient client;
    private NetSocket serverSocket;
    private NetSocket clientSocket;
    private boolean paused = false;

    public Proxy(Vertx vertx, String mqttServerHost, int mqttServerPort) {
        this.vertx = vertx;
        this.mqttServerHost = mqttServerHost;
        this.mqttServerPort = mqttServerPort;
    }

    public void start(Handler<AsyncResult<Void>> startHandler) {
        this.server = this.vertx.createNetServer();
        this.client = this.vertx.createNetClient();
        this.server.connectHandler(socket -> {
            this.serverSocket = socket;
            this.serverSocket.handler(buffer -> {
                if (!this.paused) {
                    log.info((Object)String.format("%s:%d ---> %s:%d", this.clientSocket.localAddress().host(), this.clientSocket.localAddress().port(), this.clientSocket.remoteAddress().host(), this.clientSocket.remoteAddress().port()));
                    this.clientSocket.write(buffer);
                }
            });
            this.serverSocket.closeHandler(v -> this.clientSocket.close());
        });
        Promise serverPromise = Promise.promise();
        this.server.listen(18830, SERVER_HOST, (Handler)serverPromise);
        Promise clientPromise = Promise.promise();
        this.client.connect(this.mqttServerPort, this.mqttServerHost, (Handler)clientPromise);
        CompositeFuture.all((Future)serverPromise.future(), (Future)clientPromise.future()).onComplete(ar -> {
            if (ar.succeeded()) {
                log.info((Object)String.format("Proxy server started on port %d", ((NetServer)serverPromise.future().result()).actualPort()));
                this.clientSocket = (NetSocket)clientPromise.future().result();
                log.info((Object)String.format("Proxy client connected to %s:%d", this.clientSocket.remoteAddress().host(), this.clientSocket.remoteAddress().port()));
                this.clientSocket.handler(buffer -> {
                    log.info((Object)String.format("%s:%d <--- %s:%d", this.serverSocket.localAddress().host(), this.serverSocket.localAddress().port(), this.serverSocket.remoteAddress().host(), this.serverSocket.remoteAddress().port()));
                    this.serverSocket.write(buffer);
                });
                this.clientSocket.closeHandler(v -> this.serverSocket.close());
                startHandler.handle((Object)Future.succeededFuture());
            } else {
                if (!serverPromise.future().succeeded()) {
                    log.info((Object)"Error starting proxy server", serverPromise.future().cause());
                }
                if (!clientPromise.future().succeeded()) {
                    log.info((Object)"Error connecting proxy client", clientPromise.future().cause());
                }
                startHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            }
        });
    }

    public void stop(Handler<AsyncResult<Void>> stopHandler) {
        this.client.close();
        this.server.close(done -> {
            if (done.succeeded()) {
                stopHandler.handle((Object)Future.succeededFuture());
                log.info((Object)"Proxy server stopped");
            } else {
                stopHandler.handle((Object)Future.failedFuture((Throwable)done.cause()));
            }
        });
    }

    public void pause() {
        this.paused = true;
    }

    public void resume() {
        this.paused = false;
    }
}

