/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mqtt;

import io.netty.handler.codec.mqtt.MqttConnectReturnCode;
import io.netty.handler.codec.mqtt.MqttProperties;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.vertx.codegen.annotations.CacheReturn;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.net.SocketAddress;
import io.vertx.mqtt.MqttAuth;
import io.vertx.mqtt.MqttWill;
import io.vertx.mqtt.messages.MqttDisconnectMessage;
import io.vertx.mqtt.messages.MqttPubAckMessage;
import io.vertx.mqtt.messages.MqttPubCompMessage;
import io.vertx.mqtt.messages.MqttPubRecMessage;
import io.vertx.mqtt.messages.MqttPubRelMessage;
import io.vertx.mqtt.messages.MqttPublishMessage;
import io.vertx.mqtt.messages.MqttSubscribeMessage;
import io.vertx.mqtt.messages.MqttUnsubscribeMessage;
import io.vertx.mqtt.messages.codes.MqttDisconnectReasonCode;
import io.vertx.mqtt.messages.codes.MqttPubAckReasonCode;
import io.vertx.mqtt.messages.codes.MqttPubCompReasonCode;
import io.vertx.mqtt.messages.codes.MqttPubRecReasonCode;
import io.vertx.mqtt.messages.codes.MqttPubRelReasonCode;
import io.vertx.mqtt.messages.codes.MqttSubAckReasonCode;
import io.vertx.mqtt.messages.codes.MqttUnsubAckReasonCode;
import java.util.List;
import javax.net.ssl.SSLSession;

@VertxGen
public interface MqttEndpoint {
    public void close();

    @CacheReturn
    public SocketAddress remoteAddress();

    @CacheReturn
    public SocketAddress localAddress();

    public boolean isSsl();

    public MultiMap httpHeaders();

    public String httpRequestURI();

    @GenIgnore
    public SSLSession sslSession();

    @CacheReturn
    public String clientIdentifier();

    @CacheReturn
    public MqttAuth auth();

    @CacheReturn
    public MqttWill will();

    @CacheReturn
    public int protocolVersion();

    @CacheReturn
    public String protocolName();

    @CacheReturn
    public boolean isCleanSession();

    @CacheReturn
    public int keepAliveTimeSeconds();

    @CacheReturn
    public int lastMessageId();

    public void subscriptionAutoAck(boolean var1);

    public boolean isSubscriptionAutoAck();

    @Fluent
    public MqttEndpoint publishAutoAck(boolean var1);

    public boolean isPublishAutoAck();

    @Fluent
    public MqttEndpoint autoKeepAlive(boolean var1);

    public boolean isAutoKeepAlive();

    public boolean isConnected();

    @GenIgnore(value={"permitted-type"})
    public MqttProperties connectProperties();

    @Fluent
    public MqttEndpoint setClientIdentifier(String var1);

    @Fluent
    public MqttEndpoint disconnectHandler(Handler<Void> var1);

    @Fluent
    public MqttEndpoint disconnectMessageHandler(Handler<MqttDisconnectMessage> var1);

    @Fluent
    public MqttEndpoint subscribeHandler(Handler<MqttSubscribeMessage> var1);

    @Fluent
    public MqttEndpoint unsubscribeHandler(Handler<MqttUnsubscribeMessage> var1);

    @Fluent
    public MqttEndpoint publishHandler(Handler<MqttPublishMessage> var1);

    @Fluent
    public MqttEndpoint publishAcknowledgeHandler(Handler<Integer> var1);

    @Fluent
    public MqttEndpoint publishAcknowledgeMessageHandler(Handler<MqttPubAckMessage> var1);

    @Fluent
    public MqttEndpoint publishReceivedHandler(Handler<Integer> var1);

    @Fluent
    public MqttEndpoint publishReceivedMessageHandler(Handler<MqttPubRecMessage> var1);

    @Fluent
    public MqttEndpoint publishReleaseHandler(Handler<Integer> var1);

    @Fluent
    public MqttEndpoint publishReleaseMessageHandler(Handler<MqttPubRelMessage> var1);

    @Fluent
    public MqttEndpoint publishCompletionHandler(Handler<Integer> var1);

    @Fluent
    public MqttEndpoint publishCompletionMessageHandler(Handler<MqttPubCompMessage> var1);

    @Fluent
    public MqttEndpoint pingHandler(Handler<Void> var1);

    @Fluent
    public MqttEndpoint closeHandler(Handler<Void> var1);

    @Fluent
    public MqttEndpoint exceptionHandler(Handler<Throwable> var1);

    @Fluent
    public MqttEndpoint accept();

    @Fluent
    public MqttEndpoint accept(boolean var1);

    @GenIgnore(value={"permitted-type"})
    @Fluent
    public MqttEndpoint accept(boolean var1, MqttProperties var2);

    @Fluent
    public MqttEndpoint reject(MqttConnectReturnCode var1);

    @Fluent
    @GenIgnore(value={"permitted-type"})
    public MqttEndpoint reject(MqttConnectReturnCode var1, MqttProperties var2);

    @Fluent
    public MqttEndpoint subscribeAcknowledge(int var1, List<MqttQoS> var2);

    @Fluent
    @GenIgnore(value={"permitted-type"})
    public MqttEndpoint subscribeAcknowledge(int var1, List<MqttSubAckReasonCode> var2, MqttProperties var3);

    @Fluent
    public MqttEndpoint unsubscribeAcknowledge(int var1);

    @Fluent
    @GenIgnore(value={"permitted-type"})
    public MqttEndpoint unsubscribeAcknowledge(int var1, List<MqttUnsubAckReasonCode> var2, MqttProperties var3);

    @Fluent
    public MqttEndpoint publishAcknowledge(int var1);

    @Fluent
    @GenIgnore(value={"permitted-type"})
    public MqttEndpoint publishAcknowledge(int var1, MqttPubAckReasonCode var2, MqttProperties var3);

    @Fluent
    public MqttEndpoint publishReceived(int var1);

    @GenIgnore(value={"permitted-type"})
    @Fluent
    public MqttEndpoint publishReceived(int var1, MqttPubRecReasonCode var2, MqttProperties var3);

    @Fluent
    public MqttEndpoint publishRelease(int var1);

    @Fluent
    @GenIgnore(value={"permitted-type"})
    public MqttEndpoint publishRelease(int var1, MqttPubRelReasonCode var2, MqttProperties var3);

    @Fluent
    public MqttEndpoint publishComplete(int var1);

    @Fluent
    @GenIgnore(value={"permitted-type"})
    public MqttEndpoint publishComplete(int var1, MqttPubCompReasonCode var2, MqttProperties var3);

    public Future<Integer> publish(String var1, Buffer var2, MqttQoS var3, boolean var4, boolean var5);

    @Fluent
    public MqttEndpoint publish(String var1, Buffer var2, MqttQoS var3, boolean var4, boolean var5, Handler<AsyncResult<Integer>> var6);

    public Future<Integer> publish(String var1, Buffer var2, MqttQoS var3, boolean var4, boolean var5, int var6);

    @GenIgnore(value={"permitted-type"})
    public Future<Integer> publish(String var1, Buffer var2, MqttQoS var3, boolean var4, boolean var5, int var6, MqttProperties var7);

    @Fluent
    public MqttEndpoint publish(String var1, Buffer var2, MqttQoS var3, boolean var4, boolean var5, int var6, Handler<AsyncResult<Integer>> var7);

    @Fluent
    @GenIgnore(value={"permitted-type"})
    public MqttEndpoint publish(String var1, Buffer var2, MqttQoS var3, boolean var4, boolean var5, int var6, MqttProperties var7, Handler<AsyncResult<Integer>> var8);

    @Fluent
    public MqttEndpoint pong();

    @GenIgnore(value={"permitted-type"})
    @Fluent
    public MqttEndpoint disconnect(MqttDisconnectReasonCode var1, MqttProperties var2);
}

