/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mqtt.messages.codes;

import io.vertx.mqtt.messages.codes.MqttReasonCode;

public class ReasonCodeUtils {
    static <C extends MqttReasonCode> void fillValuesByCode(C[] valuesByCode, C[] values) {
        for (C code : values) {
            int unsignedByte = code.value() & 0xFF;
            valuesByCode[unsignedByte] = code;
        }
    }

    static <C> C codeLoopkup(C[] valuesByCode, byte b, String codeType) {
        int unsignedByte = b & 0xFF;
        C reasonCode = null;
        try {
            reasonCode = valuesByCode[unsignedByte];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        if (reasonCode == null) {
            throw new IllegalArgumentException("unknown " + codeType + " reason code: " + unsignedByte);
        }
        return reasonCode;
    }
}

