/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rx.java;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.rx.java.ObservableOnSubscribeAdapter;

public class HandlerAdapter<T>
extends ObservableOnSubscribeAdapter<T>
implements Handler<AsyncResult<T>> {
    private AsyncResult<T> buffered;
    private boolean subscribed;

    @Override
    public void onSubscribed() {
        AsyncResult<T> result = this.buffered;
        if (result != null) {
            this.buffered = null;
            this.dispatch(result);
        } else {
            this.subscribed = true;
        }
    }

    public void handle(AsyncResult<T> event) {
        if (this.subscribed) {
            this.subscribed = false;
            this.dispatch(event);
        } else {
            this.buffered = event;
        }
    }

    @Override
    protected void onUnsubscribed() {
        this.subscribed = false;
    }

    protected void dispatch(AsyncResult<T> event) {
        if (event.succeeded()) {
            this.fireNext(event.result());
            this.fireComplete();
        } else {
            this.fireError(event.cause());
        }
    }
}

